/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.base.CommerceRegionServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceRegionServiceImpl
extends CommerceRegionServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceRegionServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public CommerceRegion addCommerceRegion(long commerceCountryId, String name, String code, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryPersistence.findByPrimaryKey(commerceCountryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceCountry.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.addCommerceRegion(commerceCountry.getCommerceCountryId(), name, code, priority, active, serviceContext);
    }

    public void deleteCommerceRegion(long commerceRegionId) throws PortalException {
        CommerceRegion commerceRegion = this.commerceRegionPersistence.findByPrimaryKey(commerceRegionId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceRegion.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        this.commerceRegionLocalService.deleteCommerceRegion(commerceRegion);
    }

    public CommerceRegion getCommerceRegion(long commerceRegionId) throws PortalException {
        CommerceRegion commerceRegion = this.commerceRegionLocalService.getCommerceRegion(commerceRegionId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceRegion.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return commerceRegion;
    }

    public List<CommerceRegion> getCommerceRegions(long commerceCountryId, boolean active) {
        return this.commerceRegionLocalService.getCommerceRegions(commerceCountryId, active);
    }

    public List<CommerceRegion> getCommerceRegions(long commerceCountryId, boolean active, int start, int end, OrderByComparator<CommerceRegion> orderByComparator) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryLocalService.getCommerceCountry(commerceCountryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceCountry.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.getCommerceRegions(commerceCountryId, active, start, end, orderByComparator);
    }

    public List<CommerceRegion> getCommerceRegions(long commerceCountryId, int start, int end, OrderByComparator<CommerceRegion> orderByComparator) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryLocalService.getCommerceCountry(commerceCountryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceCountry.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.getCommerceRegions(commerceCountryId, start, end, orderByComparator);
    }

    public int getCommerceRegionsCount(long commerceCountryId) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryLocalService.getCommerceCountry(commerceCountryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceCountry.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.getCommerceRegionsCount(commerceCountryId);
    }

    public int getCommerceRegionsCount(long commerceCountryId, boolean active) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryLocalService.getCommerceCountry(commerceCountryId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceCountry.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.getCommerceRegionsCount(commerceCountryId, active);
    }

    public CommerceRegion setActive(long commerceRegionId, boolean active) throws PortalException {
        CommerceRegion commerceRegion = this.commerceRegionPersistence.findByPrimaryKey(commerceRegionId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceRegion.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.setActive(commerceRegionId, active);
    }

    public CommerceRegion updateCommerceRegion(long commerceRegionId, String name, String code, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommerceRegion commerceRegion = this.commerceRegionPersistence.findByPrimaryKey(commerceRegionId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceRegion.getGroupId(), "MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.updateCommerceRegion(commerceRegion.getCommerceRegionId(), name, code, priority, active, serviceContext);
    }
}

