/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.subscription;

import com.liferay.commerce.configuration.CommerceSubscriptionConfiguration;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.commerce.subscription.CommerceSubscriptionEntryActionHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceSubscriptionEntryActionHelper.class})
public class CommerceSubscriptionEntryActionHelperImpl
implements CommerceSubscriptionEntryActionHelper {
    @Reference
    private CommerceSubscriptionEntryLocalService _commerceSubscriptionEntryLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;

    public void activateCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws PortalException {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        if (1 != commerceSubscriptionEntry.getSubscriptionStatus()) {
            return;
        }
        this._commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntryId, 0);
    }

    public void cancelCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws PortalException {
        CommerceSubscriptionConfiguration commerceSubscriptionConfiguration = (CommerceSubscriptionConfiguration)this._configurationProvider.getSystemConfiguration(CommerceSubscriptionConfiguration.class);
        if (commerceSubscriptionConfiguration.cancelSubscription()) {
            this._commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntryId, 2);
        }
    }

    public void suspendCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws PortalException {
        CommerceSubscriptionConfiguration commerceSubscriptionConfiguration = (CommerceSubscriptionConfiguration)this._configurationProvider.getSystemConfiguration(CommerceSubscriptionConfiguration.class);
        if (commerceSubscriptionConfiguration.suspendSubscription()) {
            this._commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntryId, 1);
        }
    }
}

