/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceWarehouseItem;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.service.CommerceWarehouseItemLocalService;
import com.liferay.commerce.stock.activity.CommerceLowStockActivity;
import com.liferay.commerce.stock.activity.CommerceLowStockActivityRegistry;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/stock_quantity"}, service={MessageListener.class})
public class CommerceStockQuantityMessageListener
extends BaseMessageListener {
    @Reference
    private CommerceLowStockActivityRegistry _commerceLowStockActivityRegistry;
    @Reference
    private CommerceWarehouseItemLocalService _commerceWarehouseItemLocalService;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;

    protected void doReceive(Message message) throws Exception {
        long commerceWarehouseItemId = message.getLong("commerceWarehouseItemId");
        CommerceWarehouseItem commerceWarehouseItem = this._commerceWarehouseItemLocalService.getCommerceWarehouseItem(commerceWarehouseItemId);
        CPInstance cpInstance = commerceWarehouseItem.getCPInstance();
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CommerceLowStockActivity commerceLowStockActivity = this._commerceLowStockActivityRegistry.getCommerceLowStockActivity(cpDefinitionInventory);
        if (commerceLowStockActivity == null) {
            return;
        }
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        int stockQuantity = this._commerceWarehouseItemLocalService.getCPInstanceQuantity(cpInstance.getCPInstanceId());
        if (stockQuantity <= cpDefinitionInventoryEngine.getMinStockQuantity(cpInstance)) {
            commerceLowStockActivity.execute(commerceWarehouseItem);
        }
    }
}

