/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.context;

import com.liferay.commerce.account.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.model.CPRule;
import com.liferay.commerce.product.service.CPRuleLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.user.segment.util.CommerceUserSegmentHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import java.util.List;
import java.util.Optional;

public class CommerceContextImpl
implements CommerceContext {
    private static final Log _log = LogFactoryUtil.getLog(CommerceContextImpl.class);
    private CommerceAccount _commerceAccount;
    private CommerceAccountGroupServiceConfiguration _commerceAccountGroupServiceConfiguration;
    private final long _commerceAccountId;
    private final CommerceAccountService _commerceAccountService;
    private CommerceCurrency _commerceCurrency;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private CommerceOrder _commerceOrder;
    private final CommerceOrderService _commerceOrderService;
    private Optional<CommercePriceList> _commercePriceList;
    private final CommercePriceListLocalService _commercePriceListLocalService;
    private long[] _commerceUserSegmentEntryIds;
    private final CommerceUserSegmentHelper _commerceUserSegmentHelper;
    private final String _couponCode;
    private final CPRuleLocalService _cpRuleLocalService;
    private List<CPRule> _cpRules;
    private final long _groupId;
    private final long _orderId;
    private final long _userId;

    public CommerceContextImpl(long groupId, long userId, long orderId, long commerceAccountId, String couponCode, CommerceAccountService commerceAccountService, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceOrderService commerceOrderService, CommercePriceListLocalService commercePriceListLocalService, CommerceUserSegmentHelper commerceUserSegmentHelper, ConfigurationProvider configurationProvider, CPRuleLocalService cpRuleLocalService) {
        this._groupId = groupId;
        this._userId = userId;
        this._orderId = orderId;
        this._commerceAccountId = commerceAccountId;
        this._couponCode = couponCode;
        this._commerceAccountService = commerceAccountService;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceOrderService = commerceOrderService;
        this._commercePriceListLocalService = commercePriceListLocalService;
        this._commerceUserSegmentHelper = commerceUserSegmentHelper;
        this._cpRuleLocalService = cpRuleLocalService;
        try {
            this._commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(this._groupId, "com.liferay.commerce.account"));
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
    }

    public CommerceAccount getCommerceAccount() throws PortalException {
        if (this._commerceAccount != null) {
            return this._commerceAccount;
        }
        this._commerceAccount = this._commerceAccountService.getCommerceAccount(this._commerceAccountId);
        return this._commerceAccount;
    }

    public CommerceCurrency getCommerceCurrency() throws PortalException {
        if (this._commerceCurrency != null) {
            return this._commerceCurrency;
        }
        this._commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(this._groupId);
        return this._commerceCurrency;
    }

    public CommerceOrder getCommerceOrder() throws PortalException {
        if (this._commerceOrder != null) {
            return this._commerceOrder;
        }
        this._commerceOrder = this._commerceOrderService.getCommerceOrder(this._orderId);
        return this._commerceOrder;
    }

    public Optional<CommercePriceList> getCommercePriceList() throws PortalException {
        if (this._commercePriceList != null) {
            return this._commercePriceList;
        }
        this._commercePriceList = this._commercePriceListLocalService.getCommercePriceList(this._groupId, this.getCommerceUserSegmentEntryIds());
        return this._commercePriceList;
    }

    public int getCommerceSiteType() {
        if (this._commerceAccountGroupServiceConfiguration == null) {
            return 0;
        }
        return this._commerceAccountGroupServiceConfiguration.commerceSiteType();
    }

    public long[] getCommerceUserSegmentEntryIds() throws PortalException {
        if (this._commerceUserSegmentEntryIds != null) {
            return this._commerceUserSegmentEntryIds;
        }
        this._commerceUserSegmentEntryIds = this._commerceUserSegmentHelper.getCommerceUserSegmentIds(this._groupId, this._commerceAccountId, this._userId);
        return this._commerceUserSegmentEntryIds;
    }

    public String getCouponCode() throws PortalException {
        return this._couponCode;
    }

    public List<CPRule> getCPRules() throws PortalException {
        if (this._cpRules != null) {
            return this._cpRules;
        }
        this._cpRules = this._cpRuleLocalService.getCPRules(this._groupId, this.getCommerceUserSegmentEntryIds());
        return null;
    }

    public long getSiteGroupId() throws PortalException {
        return this._groupId;
    }

    public long getUserId() {
        return this._userId;
    }
}

