/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.impl.CommerceOrderImpl;
import com.liferay.commerce.service.persistence.CommerceOrderFinder;
import com.liferay.commerce.service.persistence.impl.CommerceOrderFinderBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceOrderFinderImpl
extends CommerceOrderFinderBaseImpl
implements CommerceOrderFinder {
    public static final String FIND_BY_G_O = CommerceOrderFinder.class.getName() + ".findByG_O";
    public static final String FIND_BY_G_U_C_O_S = CommerceOrderFinder.class.getName() + ".findByG_U_C_O_S";
    public static final String GET_SHIPPED_COMMERCE_ORDERS_BY_COMMERCE_SHIPMENT_ID = CommerceOrderFinder.class.getName() + ".getShippedCommerceOrdersByCommerceShipmentId";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public CommerceOrder fetchByG_U_C_O_S_First(long groupId, long userId, long commerceAccountId, int orderStatus) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_C_O_S);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceOrder", CommerceOrderImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(commerceAccountId);
            queryPos.add(orderStatus);
            queryPos.add(userId);
            List commerceOrders = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)0, (int)1);
            if (!commerceOrders.isEmpty()) {
                CommerceOrder commerceOrder = (CommerceOrder)commerceOrders.get(0);
                return commerceOrder;
            }
            CommerceOrder commerceOrder = null;
            return commerceOrder;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceOrder> findByG_O(long groupId, int[] orderStatuses) {
        return this.doFindByG_O(groupId, orderStatuses, -1, -1);
    }

    public List<CommerceOrder> findByG_O(long groupId, int[] orderStatuses, int start, int end) {
        return this.doFindByG_O(groupId, orderStatuses, start, end);
    }

    public List<CommerceOrder> getShippedCommerceOrdersByCommerceShipmentId(long shipmentId, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), GET_SHIPPED_COMMERCE_ORDERS_BY_COMMERCE_SHIPMENT_ID);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceOrder", CommerceOrderImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(shipmentId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<CommerceOrder> doFindByG_O(long groupId, int[] orderStatuses, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_O);
            sql = this.replaceOrderStatus(sql, orderStatuses);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceOrder", CommerceOrderImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String replaceOrderStatus(String sql, int[] orderStatuses) {
        StringBundler sb = new StringBundler(orderStatuses.length);
        for (int i = 0; i < orderStatuses.length; ++i) {
            sb.append(orderStatuses[i]);
            if (i == orderStatuses.length - 1) continue;
            sb.append(", ");
        }
        return StringUtil.replace((String)sql, (String)"[$ORDER_STATUS$]", (String)sb.toString());
    }
}

