/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceOrderNoteContentException;
import com.liferay.commerce.exception.DuplicateCommerceOrderNoteException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderNote;
import com.liferay.commerce.service.base.CommerceOrderNoteLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public class CommerceOrderNoteLocalServiceImpl
extends CommerceOrderNoteLocalServiceBaseImpl {
    public CommerceOrderNote addCommerceOrderNote(long commerceOrderId, String content, boolean restricted, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceOrderNote(null, commerceOrderId, content, restricted, serviceContext);
    }

    public CommerceOrderNote addCommerceOrderNote(String externalReferenceCode, long commerceOrderId, String content, boolean restricted, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        this.validate(content);
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this.validateExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        long commerceOrderNoteId = this.counterLocalService.increment();
        CommerceOrderNote commerceOrderNote = this.commerceOrderNotePersistence.create(commerceOrderNoteId);
        commerceOrderNote.setExternalReferenceCode(externalReferenceCode);
        commerceOrderNote.setGroupId(commerceOrder.getGroupId());
        commerceOrderNote.setCompanyId(user.getCompanyId());
        commerceOrderNote.setUserId(user.getUserId());
        commerceOrderNote.setUserName(user.getFullName());
        commerceOrderNote.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderNote.setContent(content);
        commerceOrderNote.setRestricted(restricted);
        return (CommerceOrderNote)this.commerceOrderNotePersistence.update((BaseModel)commerceOrderNote);
    }

    public CommerceOrderNote addOrUpdateCommerceOrderNote(String externalReferenceCode, long commerceOrderNoteId, long commerceOrderId, String content, boolean restricted, ServiceContext serviceContext) throws PortalException {
        CommerceOrderNote commerceOrderNote;
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        if ((commerceOrderNote = commerceOrderNoteId > 0L ? this.getCommerceOrderNote(commerceOrderNoteId) : this.commerceOrderNotePersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.updateCommerceOrderNote(externalReferenceCode, commerceOrderNote.getCommerceOrderNoteId(), content, restricted);
        }
        return this.addCommerceOrderNote(externalReferenceCode, commerceOrderId, content, restricted, serviceContext);
    }

    public void deleteCommerceOrderNotes(long commerceOrderId) {
        this.commerceOrderNotePersistence.removeByCommerceOrderId(commerceOrderId);
    }

    public CommerceOrderNote fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceOrderNotePersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public List<CommerceOrderNote> getCommerceOrderNotes(long commerceOrderId, boolean restricted) {
        return this.commerceOrderNotePersistence.findByC_R(commerceOrderId, restricted);
    }

    public List<CommerceOrderNote> getCommerceOrderNotes(long commerceOrderId, int start, int end) {
        return this.commerceOrderNotePersistence.findByCommerceOrderId(commerceOrderId, start, end);
    }

    public int getCommerceOrderNotesCount(long commerceOrderId) {
        return this.commerceOrderNotePersistence.countByCommerceOrderId(commerceOrderId);
    }

    public int getCommerceOrderNotesCount(long commerceOrderId, boolean restricted) {
        return this.commerceOrderNotePersistence.countByC_R(commerceOrderId, restricted);
    }

    public CommerceOrderNote updateCommerceOrderNote(long commerceOrderNoteId, String content, boolean restricted) throws PortalException {
        return this.updateCommerceOrderNote(null, commerceOrderNoteId, content, restricted);
    }

    public CommerceOrderNote updateCommerceOrderNote(String externalReferenceCode, long commerceOrderNoteId, String content, boolean restricted) throws PortalException {
        CommerceOrderNote commerceOrderNote = this.commerceOrderNotePersistence.findByPrimaryKey(commerceOrderNoteId);
        this.validate(content);
        if (Validator.isNull((String)commerceOrderNote.getExternalReferenceCode())) {
            if (Validator.isBlank((String)externalReferenceCode)) {
                externalReferenceCode = null;
            }
            commerceOrderNote.setExternalReferenceCode(externalReferenceCode);
        }
        commerceOrderNote.setContent(content);
        commerceOrderNote.setRestricted(restricted);
        return (CommerceOrderNote)this.commerceOrderNotePersistence.update((BaseModel)commerceOrderNote);
    }

    protected void validate(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new CommerceOrderNoteContentException();
        }
    }

    protected void validateExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommerceOrderNote commerceOrderNote = this.commerceOrderNotePersistence.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceOrderNote != null) {
            throw new DuplicateCommerceOrderNoteException("There is another commerce order note with external reference code " + externalReferenceCode);
        }
    }
}

