/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.instance.lifecycle;

import com.liferay.commerce.constants.CommerceSAPConstants;
import com.liferay.commerce.helper.CommerceSAPHelper;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.oauth2.provider.scope.spi.scope.mapper.ScopeMapper;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"sap.scope.finder=true"}, service={PortalInstanceLifecycleListener.class, ScopeFinder.class, ScopeMapper.class})
public class CommerceServicePortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener
implements ScopeFinder,
ScopeMapper {
    @Reference
    private CommerceSAPHelper _commerceSAPHelper;
    private List<String> _scopeAliasesList;
    @Reference
    private UserLocalService _userLocalService;

    public Collection<String> findScopes() {
        return this._scopeAliasesList;
    }

    public Set<String> map(String scope) {
        return Collections.singleton(scope);
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        User user = this._userLocalService.getDefaultUser(company.getCompanyId());
        this._commerceSAPHelper.addCommerceDefaultSAPEntries(company.getCompanyId(), user.getUserId());
    }

    @Activate
    protected void activate() {
        Stream<String[]> stream = Arrays.stream(CommerceSAPConstants.SAP_ENTRY_OBJECT_ARRAYS);
        this._scopeAliasesList = stream.map((? super T sapEntryObjectArray) -> StringUtil.replaceFirst((String)sapEntryObjectArray[0], (String)"OAUTH2_", (String)"")).collect(Collectors.toList());
    }
}

