/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.exception.NoSuchShipmentException;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentTable;
import com.liferay.commerce.model.impl.CommerceShipmentImpl;
import com.liferay.commerce.model.impl.CommerceShipmentModelImpl;
import com.liferay.commerce.service.persistence.CommerceShipmentPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CommerceShipmentPersistenceImpl
extends BasePersistenceImpl<CommerceShipment>
implements CommerceShipmentPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceShipmentImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupIds;
    private FinderPath _finderPathWithoutPaginationFindByGroupIds;
    private FinderPath _finderPathCountByGroupIds;
    private FinderPath _finderPathWithPaginationCountByGroupIds;
    private static final String _FINDER_COLUMN_GROUPIDS_GROUPID_2 = "commerceShipment.groupId = ?";
    private static final String _FINDER_COLUMN_GROUPIDS_GROUPID_7 = "commerceShipment.groupId IN (";
    private FinderPath _finderPathWithPaginationFindByG_C;
    private FinderPath _finderPathWithoutPaginationFindByG_C;
    private FinderPath _finderPathCountByG_C;
    private FinderPath _finderPathWithPaginationCountByG_C;
    private static final String _FINDER_COLUMN_G_C_GROUPID_2 = "commerceShipment.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_GROUPID_7 = "commerceShipment.groupId IN (";
    private static final String _FINDER_COLUMN_G_C_COMMERCEADDRESSID_2 = "commerceShipment.commerceAddressId = ?";
    private FinderPath _finderPathWithPaginationFindByG_S;
    private FinderPath _finderPathWithoutPaginationFindByG_S;
    private FinderPath _finderPathCountByG_S;
    private FinderPath _finderPathWithPaginationCountByG_S;
    private static final String _FINDER_COLUMN_G_S_GROUPID_2 = "commerceShipment.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_S_GROUPID_7 = "commerceShipment.groupId IN (";
    private static final String _FINDER_COLUMN_G_S_STATUS_2 = "commerceShipment.status = ?";
    private BundleContext _bundleContext;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCESHIPMENT = "SELECT commerceShipment FROM CommerceShipment commerceShipment";
    private static final String _SQL_SELECT_COMMERCESHIPMENT_WHERE = "SELECT commerceShipment FROM CommerceShipment commerceShipment WHERE ";
    private static final String _SQL_COUNT_COMMERCESHIPMENT = "SELECT COUNT(commerceShipment) FROM CommerceShipment commerceShipment";
    private static final String _SQL_COUNT_COMMERCESHIPMENT_WHERE = "SELECT COUNT(commerceShipment) FROM CommerceShipment commerceShipment WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceShipment.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceShipment exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceShipment exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentPersistenceImpl.class);
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();

    public List<CommerceShipment> findByGroupIds(long groupId) {
        return this.findByGroupIds(groupId, -1, -1, null);
    }

    public List<CommerceShipment> findByGroupIds(long groupId, int start, int end) {
        return this.findByGroupIds(groupId, start, end, null);
    }

    public List<CommerceShipment> findByGroupIds(long groupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByGroupIds(groupId, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByGroupIds(long groupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupIds;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupIds;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (groupId == commerceShipment.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            sb.append(_FINDER_COLUMN_GROUPIDS_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByGroupIds_First(long groupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByGroupIds_First(groupId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByGroupIds_First(long groupId, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByGroupIds(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByGroupIds_Last(long groupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByGroupIds_Last(groupId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByGroupIds_Last(long groupId, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByGroupIds(groupId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByGroupIds(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByGroupIds_PrevAndNext(long commerceShipmentId, long groupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByGroupIds_PrevAndNext(session, commerceShipment, groupId, orderByComparator, true), commerceShipment, this.getByGroupIds_PrevAndNext(session, commerceShipment, groupId, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByGroupIds_PrevAndNext(Session session, CommerceShipment commerceShipment, long groupId, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        sb.append(_FINDER_COLUMN_GROUPIDS_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public List<CommerceShipment> findByGroupIds(long[] groupIds) {
        return this.findByGroupIds(groupIds, -1, -1, null);
    }

    public List<CommerceShipment> findByGroupIds(long[] groupIds, int start, int end) {
        return this.findByGroupIds(groupIds, start, end, null);
    }

    public List<CommerceShipment> findByGroupIds(long[] groupIds, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByGroupIds(groupIds, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByGroupIds(long[] groupIds, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        if (groupIds.length == 1) {
            return this.findByGroupIds(groupIds[0], start, end, orderByComparator);
        }
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderArgs = new Object[]{StringUtil.merge((long[])groupIds)};
            }
        } else if (useFinderCache) {
            finderArgs = new Object[]{StringUtil.merge((long[])groupIds), start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(this._finderPathWithPaginationFindByGroupIds, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (ArrayUtil.contains((long[])groupIds, (long)commerceShipment.getGroupId())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(this._finderPathWithPaginationFindByGroupIds, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByGroupIds(long groupId) {
        for (CommerceShipment commerceShipment : this.findByGroupIds(groupId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByGroupIds(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupIds;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            sb.append(_FINDER_COLUMN_GROUPIDS_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByGroupIds(long[] groupIds) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        Object[] finderArgs = new Object[]{StringUtil.merge((long[])groupIds)};
        Long count = (Long)this.finderCache.getResult(this._finderPathWithPaginationCountByGroupIds, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathWithPaginationCountByGroupIds, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipment> findByG_C(long groupId, long commerceAddressId) {
        return this.findByG_C(groupId, commerceAddressId, -1, -1, null);
    }

    public List<CommerceShipment> findByG_C(long groupId, long commerceAddressId, int start, int end) {
        return this.findByG_C(groupId, commerceAddressId, start, end, null);
    }

    public List<CommerceShipment> findByG_C(long groupId, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByG_C(groupId, commerceAddressId, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByG_C(long groupId, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_C;
                finderArgs = new Object[]{groupId, commerceAddressId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_C;
            finderArgs = new Object[]{groupId, commerceAddressId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (groupId == commerceShipment.getGroupId() && commerceAddressId == commerceShipment.getCommerceAddressId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(commerceAddressId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByG_C_First(long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_C_First(groupId, commerceAddressId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", commerceAddressId=");
        sb.append(commerceAddressId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByG_C_First(long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByG_C(groupId, commerceAddressId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByG_C_Last(long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_C_Last(groupId, commerceAddressId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", commerceAddressId=");
        sb.append(commerceAddressId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByG_C_Last(long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByG_C(groupId, commerceAddressId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByG_C(groupId, commerceAddressId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByG_C_PrevAndNext(long commerceShipmentId, long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByG_C_PrevAndNext(session, commerceShipment, groupId, commerceAddressId, orderByComparator, true), commerceShipment, this.getByG_C_PrevAndNext(session, commerceShipment, groupId, commerceAddressId, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByG_C_PrevAndNext(Session session, CommerceShipment commerceShipment, long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        sb.append("commerceShipment.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(commerceAddressId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public List<CommerceShipment> findByG_C(long[] groupIds, long commerceAddressId) {
        return this.findByG_C(groupIds, commerceAddressId, -1, -1, null);
    }

    public List<CommerceShipment> findByG_C(long[] groupIds, long commerceAddressId, int start, int end) {
        return this.findByG_C(groupIds, commerceAddressId, start, end, null);
    }

    public List<CommerceShipment> findByG_C(long[] groupIds, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByG_C(groupIds, commerceAddressId, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByG_C(long[] groupIds, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        if (groupIds.length == 1) {
            return this.findByG_C(groupIds[0], commerceAddressId, start, end, orderByComparator);
        }
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderArgs = new Object[]{StringUtil.merge((long[])groupIds), commerceAddressId};
            }
        } else if (useFinderCache) {
            finderArgs = new Object[]{StringUtil.merge((long[])groupIds), commerceAddressId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(this._finderPathWithPaginationFindByG_C, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (ArrayUtil.contains((long[])groupIds, (long)commerceShipment.getGroupId()) && commerceAddressId == commerceShipment.getCommerceAddressId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
                sb.append(" AND ");
            }
            sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceAddressId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(this._finderPathWithPaginationFindByG_C, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByG_C(long groupId, long commerceAddressId) {
        for (CommerceShipment commerceShipment : this.findByG_C(groupId, commerceAddressId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByG_C(long groupId, long commerceAddressId) {
        FinderPath finderPath = this._finderPathCountByG_C;
        Object[] finderArgs = new Object[]{groupId, commerceAddressId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(commerceAddressId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_C(long[] groupIds, long commerceAddressId) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        Object[] finderArgs = new Object[]{StringUtil.merge((long[])groupIds), commerceAddressId};
        Long count = (Long)this.finderCache.getResult(this._finderPathWithPaginationCountByG_C, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
                sb.append(" AND ");
            }
            sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceAddressId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathWithPaginationCountByG_C, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipment> findByG_S(long groupId, int status) {
        return this.findByG_S(groupId, status, -1, -1, null);
    }

    public List<CommerceShipment> findByG_S(long groupId, int status, int start, int end) {
        return this.findByG_S(groupId, status, start, end, null);
    }

    public List<CommerceShipment> findByG_S(long groupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByG_S(groupId, status, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByG_S(long groupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_S;
                finderArgs = new Object[]{groupId, status};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_S;
            finderArgs = new Object[]{groupId, status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (groupId == commerceShipment.getGroupId() && status == commerceShipment.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByG_S_First(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_S_First(groupId, status, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByG_S_First(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByG_S(groupId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByG_S_Last(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_S_Last(groupId, status, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByG_S_Last(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByG_S(groupId, status);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByG_S(groupId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByG_S_PrevAndNext(long commerceShipmentId, long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByG_S_PrevAndNext(session, commerceShipment, groupId, status, orderByComparator, true), commerceShipment, this.getByG_S_PrevAndNext(session, commerceShipment, groupId, status, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByG_S_PrevAndNext(Session session, CommerceShipment commerceShipment, long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        sb.append("commerceShipment.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public List<CommerceShipment> findByG_S(long[] groupIds, int status) {
        return this.findByG_S(groupIds, status, -1, -1, null);
    }

    public List<CommerceShipment> findByG_S(long[] groupIds, int status, int start, int end) {
        return this.findByG_S(groupIds, status, start, end, null);
    }

    public List<CommerceShipment> findByG_S(long[] groupIds, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByG_S(groupIds, status, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByG_S(long[] groupIds, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        if (groupIds.length == 1) {
            return this.findByG_S(groupIds[0], status, start, end, orderByComparator);
        }
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderArgs = new Object[]{StringUtil.merge((long[])groupIds), status};
            }
        } else if (useFinderCache) {
            finderArgs = new Object[]{StringUtil.merge((long[])groupIds), status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(this._finderPathWithPaginationFindByG_S, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (ArrayUtil.contains((long[])groupIds, (long)commerceShipment.getGroupId()) && status == commerceShipment.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
                sb.append(" AND ");
            }
            sb.append(_FINDER_COLUMN_G_S_STATUS_2);
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(this._finderPathWithPaginationFindByG_S, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByG_S(long groupId, int status) {
        for (CommerceShipment commerceShipment : this.findByG_S(groupId, status, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByG_S(long groupId, int status) {
        FinderPath finderPath = this._finderPathCountByG_S;
        Object[] finderArgs = new Object[]{groupId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_S_STATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_S(long[] groupIds, int status) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        Object[] finderArgs = new Object[]{StringUtil.merge((long[])groupIds), status};
        Long count = (Long)this.finderCache.getResult(this._finderPathWithPaginationCountByG_S, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
                sb.append(" AND ");
            }
            sb.append(_FINDER_COLUMN_G_S_STATUS_2);
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathWithPaginationCountByG_S, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceShipmentPersistenceImpl() {
        this.setModelClass(CommerceShipment.class);
        this.setModelImplClass(CommerceShipmentImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceShipmentTable.INSTANCE);
    }

    public void cacheResult(CommerceShipment commerceShipment) {
        this.entityCache.putResult(CommerceShipmentImpl.class, (Serializable)Long.valueOf(commerceShipment.getPrimaryKey()), (Serializable)commerceShipment);
    }

    public void cacheResult(List<CommerceShipment> commerceShipments) {
        for (CommerceShipment commerceShipment : commerceShipments) {
            if (this.entityCache.getResult(CommerceShipmentImpl.class, (Serializable)Long.valueOf(commerceShipment.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceShipment);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceShipmentImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceShipment commerceShipment) {
        this.entityCache.removeResult(CommerceShipmentImpl.class, (BaseModel)commerceShipment);
    }

    public void clearCache(List<CommerceShipment> commerceShipments) {
        for (CommerceShipment commerceShipment : commerceShipments) {
            this.entityCache.removeResult(CommerceShipmentImpl.class, (BaseModel)commerceShipment);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceShipmentImpl.class, primaryKey);
        }
    }

    public CommerceShipment create(long commerceShipmentId) {
        CommerceShipmentImpl commerceShipment = new CommerceShipmentImpl();
        commerceShipment.setNew(true);
        commerceShipment.setPrimaryKey(commerceShipmentId);
        commerceShipment.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceShipment;
    }

    public CommerceShipment remove(long commerceShipmentId) throws NoSuchShipmentException {
        return this.remove(Long.valueOf(commerceShipmentId));
    }

    public CommerceShipment remove(Serializable primaryKey) throws NoSuchShipmentException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment commerceShipment = (CommerceShipment)session.get(CommerceShipmentImpl.class, primaryKey);
            if (commerceShipment == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchShipmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceShipment commerceShipment2 = (CommerceShipment)this.remove((BaseModel)commerceShipment);
            return commerceShipment2;
        }
        catch (NoSuchShipmentException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment removeImpl(CommerceShipment commerceShipment) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceShipment)) {
                commerceShipment = (CommerceShipment)session.get(CommerceShipmentImpl.class, commerceShipment.getPrimaryKeyObj());
            }
            if (commerceShipment != null) {
                session.delete((Object)commerceShipment);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceShipment != null) {
            this.clearCache(commerceShipment);
        }
        return commerceShipment;
    }

    public CommerceShipment updateImpl(CommerceShipment commerceShipment) {
        boolean isNew = commerceShipment.isNew();
        if (!(commerceShipment instanceof CommerceShipmentModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceShipment.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceShipment);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceShipment proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceShipment implementation " + commerceShipment.getClass());
        }
        CommerceShipmentModelImpl commerceShipmentModelImpl = (CommerceShipmentModelImpl)commerceShipment;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && commerceShipment.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceShipment.setCreateDate(now);
            } else {
                commerceShipment.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!commerceShipmentModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceShipment.setModifiedDate(now);
            } else {
                commerceShipment.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceShipment);
            } else {
                commerceShipment = (CommerceShipment)session.merge((Object)commerceShipment);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceShipmentImpl.class, (BaseModel)commerceShipmentModelImpl, false, true);
        if (isNew) {
            commerceShipment.setNew(false);
        }
        commerceShipment.resetOriginalValues();
        return commerceShipment;
    }

    public CommerceShipment findByPrimaryKey(Serializable primaryKey) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = (CommerceShipment)this.fetchByPrimaryKey(primaryKey);
        if (commerceShipment == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchShipmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceShipment;
    }

    public CommerceShipment findByPrimaryKey(long commerceShipmentId) throws NoSuchShipmentException {
        return this.findByPrimaryKey(Long.valueOf(commerceShipmentId));
    }

    public CommerceShipment fetchByPrimaryKey(long commerceShipmentId) {
        return (CommerceShipment)this.fetchByPrimaryKey(Long.valueOf(commerceShipmentId));
    }

    public List<CommerceShipment> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceShipment> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceShipment> findAll(int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findAll(int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCESHIPMENT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCESHIPMENT;
                sql = sql.concat(" ORDER BY commerceShipment.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceShipment commerceShipment : this.findAll()) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCESHIPMENT);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "commerceShipmentId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCESHIPMENT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceShipmentModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Bundle bundle = FrameworkUtil.getBundle(CommerceShipmentPersistenceImpl.class);
        this._bundleContext = bundle.getBundleContext();
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CommerceShipmentModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)CommerceShipment.class.getName()));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByGroupIds = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupIds", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathWithoutPaginationFindByGroupIds = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupIds", new String[]{Long.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathCountByGroupIds = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupIds", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
        this._finderPathWithPaginationCountByGroupIds = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByGroupIds", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
        this._finderPathWithPaginationFindByG_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "commerceAddressId"}, true);
        this._finderPathWithoutPaginationFindByG_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "commerceAddressId"}, true);
        this._finderPathCountByG_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "commerceAddressId"}, false);
        this._finderPathWithPaginationCountByG_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByG_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "commerceAddressId"}, false);
        this._finderPathWithPaginationFindByG_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "status"}, true);
        this._finderPathWithoutPaginationFindByG_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"groupId", "status"}, true);
        this._finderPathCountByG_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"groupId", "status"}, false);
        this._finderPathWithPaginationCountByG_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByG_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"groupId", "status"}, false);
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceShipmentImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class CommerceShipmentModelArgumentsResolver
    implements ArgumentsResolver {
        private static Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private CommerceShipmentModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            CommerceShipmentModelImpl commerceShipmentModelImpl = (CommerceShipmentModelImpl)baseModel;
            long columnBitmask = commerceShipmentModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return this._getValue(commerceShipmentModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CommerceShipmentModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return this._getValue(commerceShipmentModelImpl, columnNames, original);
            }
            return null;
        }

        private Object[] _getValue(CommerceShipmentModelImpl commerceShipmentModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? commerceShipmentModelImpl.getColumnOriginalValue(columnName) : commerceShipmentModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

