/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.base.CommerceRegionServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceRegionServiceImpl
extends CommerceRegionServiceBaseImpl {
    public CommerceRegion addCommerceRegion(long commerceCountryId, String name, String code, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.addCommerceRegion(commerceCountryId, name, code, priority, active, serviceContext);
    }

    public void deleteCommerceRegion(long commerceRegionId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        this.commerceRegionLocalService.deleteCommerceRegion(commerceRegionId);
    }

    public CommerceRegion getCommerceRegion(long commerceRegionId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.getCommerceRegion(commerceRegionId);
    }

    public List<CommerceRegion> getCommerceRegions(long commerceCountryId, boolean active) {
        return this.commerceRegionLocalService.getCommerceRegions(commerceCountryId, active);
    }

    public List<CommerceRegion> getCommerceRegions(long commerceCountryId, boolean active, int start, int end, OrderByComparator<CommerceRegion> orderByComparator) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.getCommerceRegions(commerceCountryId, active, start, end, orderByComparator);
    }

    public List<CommerceRegion> getCommerceRegions(long commerceCountryId, int start, int end, OrderByComparator<CommerceRegion> orderByComparator) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.getCommerceRegions(commerceCountryId, start, end, orderByComparator);
    }

    public List<CommerceRegion> getCommerceRegions(long companyId, String countryTwoLettersISOCode, boolean active) throws PortalException {
        return this.commerceRegionLocalService.getCommerceRegions(companyId, countryTwoLettersISOCode, active);
    }

    public int getCommerceRegionsCount(long commerceCountryId) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.getCommerceRegionsCount(commerceCountryId);
    }

    public int getCommerceRegionsCount(long commerceCountryId, boolean active) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.getCommerceRegionsCount(commerceCountryId, active);
    }

    public CommerceRegion setActive(long commerceRegionId, boolean active) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.setActive(commerceRegionId, active);
    }

    public CommerceRegion updateCommerceRegion(long commerceRegionId, String name, String code, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommerceRegion commerceRegion = this.commerceRegionPersistence.findByPrimaryKey(commerceRegionId);
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"MANAGE_COMMERCE_COUNTRIES");
        return this.commerceRegionLocalService.updateCommerceRegion(commerceRegion.getCommerceRegionId(), name, code, priority, active, serviceContext);
    }
}

