/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.stock.activity.CommerceLowStockActivity;
import com.liferay.commerce.stock.activity.CommerceLowStockActivityRegistry;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"destination.name=liferay/stock_quantity"}, service={MessageListener.class})
public class CommerceStockQuantityMessageListener
extends BaseMessageListener {
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CommerceLowStockActivityRegistry _commerceLowStockActivityRegistry;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;

    protected void doReceive(Message message) throws Exception {
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine;
        long cpInstanceId = message.getLong("cpInstanceId");
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return;
        }
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CommerceLowStockActivity commerceLowStockActivity = this._commerceLowStockActivityRegistry.getCommerceLowStockActivity(cpDefinitionInventory);
        if (commerceLowStockActivity == null) {
            return;
        }
        int stockQuantity = this._commerceInventoryEngine.getStockQuantity(cpInstance.getCompanyId(), cpInstance.getSku());
        if (stockQuantity <= (cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory)).getMinStockQuantity(cpInstance)) {
            commerceLowStockActivity.execute(cpInstance);
        }
    }
}

