/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.model.CommerceWarehouse;
import com.liferay.commerce.model.impl.CommerceWarehouseImpl;
import com.liferay.commerce.service.persistence.CommerceWarehouseFinder;
import com.liferay.commerce.service.persistence.impl.CommerceWarehouseFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Iterator;
import java.util.List;

public class CommerceWarehouseFinderImpl
extends CommerceWarehouseFinderBaseImpl
implements CommerceWarehouseFinder {
    public static final String COUNT_BY_G_N_D_S_C_Z_C = CommerceWarehouseFinder.class.getName() + ".countByG_N_D_S_C_Z_C";
    public static final String FIND_BY_CP_INSTANCE_ID = CommerceWarehouseFinder.class.getName() + ".findByCPInstanceId";
    public static final String FIND_BY_G_N_D_S_C_Z_C = CommerceWarehouseFinder.class.getName() + ".findByG_N_D_S_C_Z_C";
    private static final String _ACTIVE_SQL = "AND (CommerceWarehouse.active_ = ?)";
    private static final String _ALL_SQL = "[$ALL$]";
    private static final String _COMMERCE_COUNTRY_ID_SQL = "AND (CommerceWarehouse.commerceCountryId = ?)";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countByKeywords(long groupId, String keywords, Boolean active, long commerceCountryId) {
        String[] names = null;
        String[] descriptions = null;
        String[] streets = null;
        String[] cities = null;
        String[] zips = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = this._customSQL.keywords(keywords);
            descriptions = this._customSQL.keywords(keywords, false);
            streets = this._customSQL.keywords(keywords);
            cities = this._customSQL.keywords(keywords);
            zips = this._customSQL.keywords(keywords);
        } else {
            andOperator = true;
        }
        return this.countByG_N_D_S_C_Z_C(groupId, names, descriptions, streets, cities, zips, active, commerceCountryId, andOperator);
    }

    public int countByG_N_D_S_C_Z_C(long groupId, String name, String description, String street, String city, String zip, Boolean active, long commerceCountryId, boolean andOperator) {
        String[] names = this._customSQL.keywords(name);
        String[] descriptions = this._customSQL.keywords(description);
        String[] streets = this._customSQL.keywords(street);
        String[] cities = this._customSQL.keywords(city);
        String[] zips = this._customSQL.keywords(zip);
        return this.countByG_N_D_S_C_Z_C(groupId, names, descriptions, streets, cities, zips, active, commerceCountryId, andOperator);
    }

    public int countByG_N_D_S_C_Z_C(long groupId, String[] names, String[] descriptions, String[] streets, String[] cities, String[] zips, Boolean active, long commerceCountryId, boolean andOperator) {
        names = this._customSQL.keywords(names);
        descriptions = this._customSQL.keywords(descriptions, false);
        streets = this._customSQL.keywords(streets);
        cities = this._customSQL.keywords(cities);
        zips = this._customSQL.keywords(zips);
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_N_D_S_C_Z_C);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.name)", "LIKE", false, names);
            sql = this._customSQL.replaceKeywords(sql, "CommerceWarehouse.description", "LIKE", false, descriptions);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.street1)", "LIKE", true, streets);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.street2)", "LIKE", true, streets);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.street3)", "LIKE", true, streets);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.cities)", "LIKE", false, cities);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.zips)", "LIKE", false, zips);
            sql = active == null ? StringUtil.replace((String)sql, (String)_ALL_SQL, (String)"") : StringUtil.replace((String)sql, (String)_ALL_SQL, (String)_ACTIVE_SQL);
            if (commerceCountryId < 0L) {
                sql = StringUtil.replace((String)sql, (String)_COMMERCE_COUNTRY_ID_SQL, (String)"");
            }
            sql = this._customSQL.replaceAndOperator(sql, andOperator);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            qPos.add(streets, 6);
            qPos.add(cities, 2);
            qPos.add(zips, 2);
            if (commerceCountryId >= 0L) {
                qPos.add(commerceCountryId);
            }
            if (active != null) {
                qPos.add(active);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceWarehouse> findByCPInstanceId(long cpInstanceId, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_CP_INSTANCE_ID);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CommerceWarehouse", CommerceWarehouseImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(cpInstanceId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceWarehouse> findByKeywords(long groupId, String keywords, Boolean active, long commerceCountryId, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) {
        String[] names = null;
        String[] descriptions = null;
        String[] streets = null;
        String[] cities = null;
        String[] zips = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = this._customSQL.keywords(keywords);
            descriptions = this._customSQL.keywords(keywords, false);
            streets = this._customSQL.keywords(keywords);
            cities = this._customSQL.keywords(keywords);
            zips = this._customSQL.keywords(keywords);
        } else {
            andOperator = true;
        }
        return this.findByG_N_D_S_C_Z_C(groupId, names, descriptions, streets, cities, zips, active, commerceCountryId, andOperator, start, end, orderByComparator);
    }

    public List<CommerceWarehouse> findByG_N_D_S_C_Z_C(long groupId, String name, String description, String street, String city, String zip, Boolean active, long commerceCountryId, boolean andOperator, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) {
        String[] names = this._customSQL.keywords(name);
        String[] descriptions = this._customSQL.keywords(description);
        String[] streets = this._customSQL.keywords(street);
        String[] cities = this._customSQL.keywords(city);
        String[] zips = this._customSQL.keywords(zip);
        return this.findByG_N_D_S_C_Z_C(groupId, names, descriptions, streets, cities, zips, active, commerceCountryId, andOperator, start, end, orderByComparator);
    }

    public List<CommerceWarehouse> findByG_N_D_S_C_Z_C(long groupId, String[] names, String[] descriptions, String[] streets, String[] cities, String[] zips, Boolean active, long commerceCountryId, boolean andOperator, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) {
        names = this._customSQL.keywords(names);
        descriptions = this._customSQL.keywords(descriptions, false);
        streets = this._customSQL.keywords(streets);
        cities = this._customSQL.keywords(cities);
        zips = this._customSQL.keywords(zips);
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_N_D_S_C_Z_C);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.name)", "LIKE", false, names);
            sql = this._customSQL.replaceKeywords(sql, "CommerceWarehouse.description", "LIKE", false, descriptions);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.street1)", "LIKE", true, streets);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.street2)", "LIKE", true, streets);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.street3)", "LIKE", true, streets);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.cities)", "LIKE", false, cities);
            sql = this._customSQL.replaceKeywords(sql, "lower(CommerceWarehouse.zips)", "LIKE", false, zips);
            sql = active == null ? StringUtil.replace((String)sql, (String)_ALL_SQL, (String)"") : StringUtil.replace((String)sql, (String)_ALL_SQL, (String)_ACTIVE_SQL);
            if (commerceCountryId < 0L) {
                sql = StringUtil.replace((String)sql, (String)_COMMERCE_COUNTRY_ID_SQL, (String)"");
            }
            sql = this._customSQL.replaceAndOperator(sql, andOperator);
            sql = this._customSQL.replaceOrderBy(sql, orderByComparator);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CommerceWarehouse", CommerceWarehouseImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            qPos.add(streets, 6);
            qPos.add(cities, 2);
            qPos.add(zips, 2);
            if (commerceCountryId >= 0L) {
                qPos.add(commerceCountryId);
            }
            if (active != null) {
                qPos.add(active);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

