/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.commerce.exception.NoSuchPaymentMethodException;
import com.liferay.commerce.model.CommercePaymentMethod;
import com.liferay.commerce.model.impl.CommercePaymentMethodImpl;
import com.liferay.commerce.model.impl.CommercePaymentMethodModelImpl;
import com.liferay.commerce.service.persistence.CommercePaymentMethodPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class CommercePaymentMethodPersistenceImpl
extends BasePersistenceImpl<CommercePaymentMethod>
implements CommercePaymentMethodPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommercePaymentMethodImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, CommercePaymentMethodImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, CommercePaymentMethodImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, CommercePaymentMethodImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, CommercePaymentMethodImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 12L);
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "commercePaymentMethod.groupId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_G_E = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, CommercePaymentMethodImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_E", new String[]{Long.class.getName(), String.class.getName()}, 6L);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_E = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_E", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_G_E_GROUPID_2 = "commercePaymentMethod.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_E_ENGINEKEY_1 = "commercePaymentMethod.engineKey IS NULL";
    private static final String _FINDER_COLUMN_G_E_ENGINEKEY_2 = "commercePaymentMethod.engineKey = ?";
    private static final String _FINDER_COLUMN_G_E_ENGINEKEY_3 = "(commercePaymentMethod.engineKey IS NULL OR commercePaymentMethod.engineKey = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_G_A = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, CommercePaymentMethodImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_A", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_A = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, CommercePaymentMethodImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_A", new String[]{Long.class.getName(), Boolean.class.getName()}, 13L);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_A = new FinderPath(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_A", new String[]{Long.class.getName(), Boolean.class.getName()});
    private static final String _FINDER_COLUMN_G_A_GROUPID_2 = "commercePaymentMethod.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_A_ACTIVE_2 = "commercePaymentMethod.active = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCEPAYMENTMETHOD = "SELECT commercePaymentMethod FROM CommercePaymentMethod commercePaymentMethod";
    private static final String _SQL_SELECT_COMMERCEPAYMENTMETHOD_WHERE_PKS_IN = "SELECT commercePaymentMethod FROM CommercePaymentMethod commercePaymentMethod WHERE commercePaymentMethodId IN (";
    private static final String _SQL_SELECT_COMMERCEPAYMENTMETHOD_WHERE = "SELECT commercePaymentMethod FROM CommercePaymentMethod commercePaymentMethod WHERE ";
    private static final String _SQL_COUNT_COMMERCEPAYMENTMETHOD = "SELECT COUNT(commercePaymentMethod) FROM CommercePaymentMethod commercePaymentMethod";
    private static final String _SQL_COUNT_COMMERCEPAYMENTMETHOD_WHERE = "SELECT COUNT(commercePaymentMethod) FROM CommercePaymentMethod commercePaymentMethod WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commercePaymentMethod.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommercePaymentMethod exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommercePaymentMethod exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommercePaymentMethodPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"active"});

    public List<CommercePaymentMethod> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<CommercePaymentMethod> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<CommercePaymentMethod> findByGroupId(long groupId, int start, int end, OrderByComparator<CommercePaymentMethod> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<CommercePaymentMethod> findByGroupId(long groupId, int start, int end, OrderByComparator<CommercePaymentMethod> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List<CommercePaymentMethod> list = null;
        if (retrieveFromCache && (list = (List<CommercePaymentMethod>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommercePaymentMethod commercePaymentMethod : list) {
                if (groupId == commercePaymentMethod.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCEPAYMENTMETHOD_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY commercePaymentMethod.priority ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommercePaymentMethod findByGroupId_First(long groupId, OrderByComparator<CommercePaymentMethod> orderByComparator) throws NoSuchPaymentMethodException {
        CommercePaymentMethod commercePaymentMethod = this.fetchByGroupId_First(groupId, orderByComparator);
        if (commercePaymentMethod != null) {
            return commercePaymentMethod;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchPaymentMethodException(msg.toString());
    }

    public CommercePaymentMethod fetchByGroupId_First(long groupId, OrderByComparator<CommercePaymentMethod> orderByComparator) {
        List<CommercePaymentMethod> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommercePaymentMethod findByGroupId_Last(long groupId, OrderByComparator<CommercePaymentMethod> orderByComparator) throws NoSuchPaymentMethodException {
        CommercePaymentMethod commercePaymentMethod = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (commercePaymentMethod != null) {
            return commercePaymentMethod;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchPaymentMethodException(msg.toString());
    }

    public CommercePaymentMethod fetchByGroupId_Last(long groupId, OrderByComparator<CommercePaymentMethod> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<CommercePaymentMethod> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommercePaymentMethod[] findByGroupId_PrevAndNext(long commercePaymentMethodId, long groupId, OrderByComparator<CommercePaymentMethod> orderByComparator) throws NoSuchPaymentMethodException {
        CommercePaymentMethod commercePaymentMethod = this.findByPrimaryKey(commercePaymentMethodId);
        Session session = null;
        try {
            session = this.openSession();
            CommercePaymentMethod[] array = new CommercePaymentMethodImpl[]{this.getByGroupId_PrevAndNext(session, commercePaymentMethod, groupId, orderByComparator, true), commercePaymentMethod, this.getByGroupId_PrevAndNext(session, commercePaymentMethod, groupId, orderByComparator, false)};
            CommercePaymentMethod[] commercePaymentMethodArray = array;
            return commercePaymentMethodArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommercePaymentMethod getByGroupId_PrevAndNext(Session session, CommercePaymentMethod commercePaymentMethod, long groupId, OrderByComparator<CommercePaymentMethod> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCEPAYMENTMETHOD_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commercePaymentMethod.priority ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)commercePaymentMethod)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommercePaymentMethod)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (CommercePaymentMethod commercePaymentMethod : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)commercePaymentMethod);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GROUPID;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCEPAYMENTMETHOD_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommercePaymentMethod findByG_E(long groupId, String engineKey) throws NoSuchPaymentMethodException {
        CommercePaymentMethod commercePaymentMethod = this.fetchByG_E(groupId, engineKey);
        if (commercePaymentMethod == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", engineKey=");
            msg.append(engineKey);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchPaymentMethodException(msg.toString());
        }
        return commercePaymentMethod;
    }

    public CommercePaymentMethod fetchByG_E(long groupId, String engineKey) {
        return this.fetchByG_E(groupId, engineKey, true);
    }

    public CommercePaymentMethod fetchByG_E(long groupId, String engineKey, boolean retrieveFromCache) {
        CommercePaymentMethod commercePaymentMethod;
        Object[] finderArgs = new Object[]{groupId, engineKey};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_G_E, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommercePaymentMethod && (groupId != (commercePaymentMethod = (CommercePaymentMethod)result).getGroupId() || !Objects.equals(engineKey, commercePaymentMethod.getEngineKey()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_COMMERCEPAYMENTMETHOD_WHERE);
            query.append("commercePaymentMethod.groupId = ? AND ");
            boolean bindEngineKey = false;
            if (engineKey == null) {
                query.append(_FINDER_COLUMN_G_E_ENGINEKEY_1);
            } else if (engineKey.equals("")) {
                query.append(_FINDER_COLUMN_G_E_ENGINEKEY_3);
            } else {
                bindEngineKey = true;
                query.append(_FINDER_COLUMN_G_E_ENGINEKEY_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (bindEngineKey) {
                    qPos.add(engineKey);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_E, finderArgs, (Object)list);
                } else {
                    CommercePaymentMethod commercePaymentMethod2 = (CommercePaymentMethod)list.get(0);
                    result = commercePaymentMethod2;
                    this.cacheResult(commercePaymentMethod2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_E, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommercePaymentMethod)result;
    }

    public CommercePaymentMethod removeByG_E(long groupId, String engineKey) throws NoSuchPaymentMethodException {
        CommercePaymentMethod commercePaymentMethod = this.findByG_E(groupId, engineKey);
        return (CommercePaymentMethod)this.remove((BaseModel)commercePaymentMethod);
    }

    public int countByG_E(long groupId, String engineKey) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_E;
        Object[] finderArgs = new Object[]{groupId, engineKey};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_COMMERCEPAYMENTMETHOD_WHERE);
            query.append("commercePaymentMethod.groupId = ? AND ");
            boolean bindEngineKey = false;
            if (engineKey == null) {
                query.append(_FINDER_COLUMN_G_E_ENGINEKEY_1);
            } else if (engineKey.equals("")) {
                query.append(_FINDER_COLUMN_G_E_ENGINEKEY_3);
            } else {
                bindEngineKey = true;
                query.append(_FINDER_COLUMN_G_E_ENGINEKEY_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (bindEngineKey) {
                    qPos.add(engineKey);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommercePaymentMethod> findByG_A(long groupId, boolean active) {
        return this.findByG_A(groupId, active, -1, -1, null);
    }

    public List<CommercePaymentMethod> findByG_A(long groupId, boolean active, int start, int end) {
        return this.findByG_A(groupId, active, start, end, null);
    }

    public List<CommercePaymentMethod> findByG_A(long groupId, boolean active, int start, int end, OrderByComparator<CommercePaymentMethod> orderByComparator) {
        return this.findByG_A(groupId, active, start, end, orderByComparator, true);
    }

    public List<CommercePaymentMethod> findByG_A(long groupId, boolean active, int start, int end, OrderByComparator<CommercePaymentMethod> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_A;
            finderArgs = new Object[]{groupId, active};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_G_A;
            finderArgs = new Object[]{groupId, active, start, end, orderByComparator};
        }
        List<CommercePaymentMethod> list = null;
        if (retrieveFromCache && (list = (List<CommercePaymentMethod>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommercePaymentMethod commercePaymentMethod : list) {
                if (groupId == commercePaymentMethod.getGroupId() && active == commercePaymentMethod.isActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_COMMERCEPAYMENTMETHOD_WHERE);
            query.append("commercePaymentMethod.groupId = ? AND ");
            query.append(_FINDER_COLUMN_G_A_ACTIVE_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY commercePaymentMethod.priority ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(active);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommercePaymentMethod findByG_A_First(long groupId, boolean active, OrderByComparator<CommercePaymentMethod> orderByComparator) throws NoSuchPaymentMethodException {
        CommercePaymentMethod commercePaymentMethod = this.fetchByG_A_First(groupId, active, orderByComparator);
        if (commercePaymentMethod != null) {
            return commercePaymentMethod;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchPaymentMethodException(msg.toString());
    }

    public CommercePaymentMethod fetchByG_A_First(long groupId, boolean active, OrderByComparator<CommercePaymentMethod> orderByComparator) {
        List<CommercePaymentMethod> list = this.findByG_A(groupId, active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommercePaymentMethod findByG_A_Last(long groupId, boolean active, OrderByComparator<CommercePaymentMethod> orderByComparator) throws NoSuchPaymentMethodException {
        CommercePaymentMethod commercePaymentMethod = this.fetchByG_A_Last(groupId, active, orderByComparator);
        if (commercePaymentMethod != null) {
            return commercePaymentMethod;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchPaymentMethodException(msg.toString());
    }

    public CommercePaymentMethod fetchByG_A_Last(long groupId, boolean active, OrderByComparator<CommercePaymentMethod> orderByComparator) {
        int count = this.countByG_A(groupId, active);
        if (count == 0) {
            return null;
        }
        List<CommercePaymentMethod> list = this.findByG_A(groupId, active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommercePaymentMethod[] findByG_A_PrevAndNext(long commercePaymentMethodId, long groupId, boolean active, OrderByComparator<CommercePaymentMethod> orderByComparator) throws NoSuchPaymentMethodException {
        CommercePaymentMethod commercePaymentMethod = this.findByPrimaryKey(commercePaymentMethodId);
        Session session = null;
        try {
            session = this.openSession();
            CommercePaymentMethod[] array = new CommercePaymentMethodImpl[]{this.getByG_A_PrevAndNext(session, commercePaymentMethod, groupId, active, orderByComparator, true), commercePaymentMethod, this.getByG_A_PrevAndNext(session, commercePaymentMethod, groupId, active, orderByComparator, false)};
            CommercePaymentMethod[] commercePaymentMethodArray = array;
            return commercePaymentMethodArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommercePaymentMethod getByG_A_PrevAndNext(Session session, CommercePaymentMethod commercePaymentMethod, long groupId, boolean active, OrderByComparator<CommercePaymentMethod> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_COMMERCEPAYMENTMETHOD_WHERE);
        query.append("commercePaymentMethod.groupId = ? AND ");
        query.append(_FINDER_COLUMN_G_A_ACTIVE_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commercePaymentMethod.priority ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(active);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)commercePaymentMethod)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommercePaymentMethod)list.get(1);
        }
        return null;
    }

    public void removeByG_A(long groupId, boolean active) {
        for (CommercePaymentMethod commercePaymentMethod : this.findByG_A(groupId, active, -1, -1, null)) {
            this.remove((BaseModel)commercePaymentMethod);
        }
    }

    public int countByG_A(long groupId, boolean active) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_A;
        Object[] finderArgs = new Object[]{groupId, active};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_COMMERCEPAYMENTMETHOD_WHERE);
            query.append("commercePaymentMethod.groupId = ? AND ");
            query.append(_FINDER_COLUMN_G_A_ACTIVE_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(active);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommercePaymentMethodPersistenceImpl() {
        block2: {
            this.setModelClass(CommercePaymentMethod.class);
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                HashMap<String, String> dbColumnNames = new HashMap<String, String>();
                dbColumnNames.put("active", "active_");
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cacheResult(CommercePaymentMethod commercePaymentMethod) {
        this.entityCache.putResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, (Serializable)Long.valueOf(commercePaymentMethod.getPrimaryKey()), (Serializable)commercePaymentMethod);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_E, new Object[]{commercePaymentMethod.getGroupId(), commercePaymentMethod.getEngineKey()}, (Object)commercePaymentMethod);
        commercePaymentMethod.resetOriginalValues();
    }

    public void cacheResult(List<CommercePaymentMethod> commercePaymentMethods) {
        for (CommercePaymentMethod commercePaymentMethod : commercePaymentMethods) {
            if (this.entityCache.getResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, (Serializable)Long.valueOf(commercePaymentMethod.getPrimaryKey())) == null) {
                this.cacheResult(commercePaymentMethod);
                continue;
            }
            commercePaymentMethod.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommercePaymentMethodImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommercePaymentMethod commercePaymentMethod) {
        this.entityCache.removeResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, (Serializable)Long.valueOf(commercePaymentMethod.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((CommercePaymentMethodModelImpl)commercePaymentMethod, true);
    }

    public void clearCache(List<CommercePaymentMethod> commercePaymentMethods) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (CommercePaymentMethod commercePaymentMethod : commercePaymentMethods) {
            this.entityCache.removeResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, (Serializable)Long.valueOf(commercePaymentMethod.getPrimaryKey()));
            this.clearUniqueFindersCache((CommercePaymentMethodModelImpl)commercePaymentMethod, true);
        }
    }

    protected void cacheUniqueFindersCache(CommercePaymentMethodModelImpl commercePaymentMethodModelImpl) {
        Object[] args = new Object[]{commercePaymentMethodModelImpl.getGroupId(), commercePaymentMethodModelImpl.getEngineKey()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_G_E, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_G_E, args, (Object)commercePaymentMethodModelImpl, false);
    }

    protected void clearUniqueFindersCache(CommercePaymentMethodModelImpl commercePaymentMethodModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{commercePaymentMethodModelImpl.getGroupId(), commercePaymentMethodModelImpl.getEngineKey()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_E, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_E, args);
        }
        if ((commercePaymentMethodModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_E.getColumnBitmask()) != 0L) {
            args = new Object[]{commercePaymentMethodModelImpl.getOriginalGroupId(), commercePaymentMethodModelImpl.getOriginalEngineKey()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_E, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_G_E, args);
        }
    }

    public CommercePaymentMethod create(long commercePaymentMethodId) {
        CommercePaymentMethodImpl commercePaymentMethod = new CommercePaymentMethodImpl();
        commercePaymentMethod.setNew(true);
        commercePaymentMethod.setPrimaryKey(commercePaymentMethodId);
        commercePaymentMethod.setCompanyId(this.companyProvider.getCompanyId());
        return commercePaymentMethod;
    }

    public CommercePaymentMethod remove(long commercePaymentMethodId) throws NoSuchPaymentMethodException {
        return this.remove(Long.valueOf(commercePaymentMethodId));
    }

    public CommercePaymentMethod remove(Serializable primaryKey) throws NoSuchPaymentMethodException {
        Session session = null;
        try {
            session = this.openSession();
            CommercePaymentMethod commercePaymentMethod = (CommercePaymentMethod)session.get(CommercePaymentMethodImpl.class, primaryKey);
            if (commercePaymentMethod == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchPaymentMethodException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommercePaymentMethod commercePaymentMethod2 = (CommercePaymentMethod)this.remove((BaseModel)commercePaymentMethod);
            return commercePaymentMethod2;
        }
        catch (NoSuchPaymentMethodException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommercePaymentMethod removeImpl(CommercePaymentMethod commercePaymentMethod) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commercePaymentMethod)) {
                commercePaymentMethod = (CommercePaymentMethod)session.get(CommercePaymentMethodImpl.class, commercePaymentMethod.getPrimaryKeyObj());
            }
            if (commercePaymentMethod != null) {
                session.delete((Object)commercePaymentMethod);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (commercePaymentMethod != null) {
            this.clearCache(commercePaymentMethod);
        }
        return commercePaymentMethod;
    }

    public CommercePaymentMethod updateImpl(CommercePaymentMethod commercePaymentMethod) {
        boolean isNew = commercePaymentMethod.isNew();
        if (!(commercePaymentMethod instanceof CommercePaymentMethodModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commercePaymentMethod.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commercePaymentMethod);
                throw new IllegalArgumentException("Implement ModelWrapper in commercePaymentMethod proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommercePaymentMethod implementation " + commercePaymentMethod.getClass());
        }
        CommercePaymentMethodModelImpl commercePaymentMethodModelImpl = (CommercePaymentMethodModelImpl)commercePaymentMethod;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && commercePaymentMethod.getCreateDate() == null) {
            if (serviceContext == null) {
                commercePaymentMethod.setCreateDate(now);
            } else {
                commercePaymentMethod.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!commercePaymentMethodModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commercePaymentMethod.setModifiedDate(now);
            } else {
                commercePaymentMethod.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (commercePaymentMethod.isNew()) {
                session.save((Object)commercePaymentMethod);
                commercePaymentMethod.setNew(false);
            } else {
                commercePaymentMethod = (CommercePaymentMethod)session.merge((Object)commercePaymentMethod);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CommercePaymentMethodModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{commercePaymentMethodModelImpl.getGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
            args = new Object[]{commercePaymentMethodModelImpl.getGroupId(), commercePaymentMethodModelImpl.isActive()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_A, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_A, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((commercePaymentMethodModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID.getColumnBitmask()) != 0L) {
                args = new Object[]{commercePaymentMethodModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
                args = new Object[]{commercePaymentMethodModelImpl.getGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
            }
            if ((commercePaymentMethodModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_A.getColumnBitmask()) != 0L) {
                args = new Object[]{commercePaymentMethodModelImpl.getOriginalGroupId(), commercePaymentMethodModelImpl.getOriginalActive()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_A, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_A, args);
                args = new Object[]{commercePaymentMethodModelImpl.getGroupId(), commercePaymentMethodModelImpl.isActive()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_A, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_A, args);
            }
        }
        this.entityCache.putResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, (Serializable)Long.valueOf(commercePaymentMethod.getPrimaryKey()), (Serializable)commercePaymentMethod, false);
        this.clearUniqueFindersCache(commercePaymentMethodModelImpl, false);
        this.cacheUniqueFindersCache(commercePaymentMethodModelImpl);
        commercePaymentMethod.resetOriginalValues();
        return commercePaymentMethod;
    }

    public CommercePaymentMethod findByPrimaryKey(Serializable primaryKey) throws NoSuchPaymentMethodException {
        CommercePaymentMethod commercePaymentMethod = this.fetchByPrimaryKey(primaryKey);
        if (commercePaymentMethod == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchPaymentMethodException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commercePaymentMethod;
    }

    public CommercePaymentMethod findByPrimaryKey(long commercePaymentMethodId) throws NoSuchPaymentMethodException {
        return this.findByPrimaryKey(Long.valueOf(commercePaymentMethodId));
    }

    public CommercePaymentMethod fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        CommercePaymentMethod commercePaymentMethod = (CommercePaymentMethod)serializable;
        if (commercePaymentMethod == null) {
            Session session = null;
            try {
                session = this.openSession();
                commercePaymentMethod = (CommercePaymentMethod)session.get(CommercePaymentMethodImpl.class, primaryKey);
                if (commercePaymentMethod != null) {
                    this.cacheResult(commercePaymentMethod);
                } else {
                    this.entityCache.putResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return commercePaymentMethod;
    }

    public CommercePaymentMethod fetchByPrimaryKey(long commercePaymentMethodId) {
        return this.fetchByPrimaryKey(Long.valueOf(commercePaymentMethodId));
    }

    public Map<Serializable, CommercePaymentMethod> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, CommercePaymentMethod> map = new HashMap<Serializable, CommercePaymentMethod>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            CommercePaymentMethod commercePaymentMethod = this.fetchByPrimaryKey(primaryKey);
            if (commercePaymentMethod != null) {
                map.put(primaryKey, commercePaymentMethod);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (CommercePaymentMethod)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_COMMERCEPAYMENTMETHOD_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (CommercePaymentMethod commercePaymentMethod : q.list()) {
                map.put(commercePaymentMethod.getPrimaryKeyObj(), commercePaymentMethod);
                this.cacheResult(commercePaymentMethod);
                uncachedPrimaryKeys.remove(commercePaymentMethod.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(CommercePaymentMethodModelImpl.ENTITY_CACHE_ENABLED, CommercePaymentMethodImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<CommercePaymentMethod> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommercePaymentMethod> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommercePaymentMethod> findAll(int start, int end, OrderByComparator<CommercePaymentMethod> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommercePaymentMethod> findAll(int start, int end, OrderByComparator<CommercePaymentMethod> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_COMMERCEPAYMENTMETHOD);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COMMERCEPAYMENTMETHOD;
                if (pagination) {
                    sql = sql.concat(" ORDER BY commercePaymentMethod.priority ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommercePaymentMethod commercePaymentMethod : this.findAll()) {
            this.remove((BaseModel)commercePaymentMethod);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COMMERCEPAYMENTMETHOD);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommercePaymentMethodModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(CommercePaymentMethodImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

