/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceWarehouse;
import com.liferay.commerce.service.base.CommerceWarehouseServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceWarehouseServiceImpl
extends CommerceWarehouseServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceWarehouseServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public CommerceWarehouse addCommerceWarehouse(String name, String description, boolean active, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.addCommerceWarehouse(name, description, active, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, latitude, longitude, serviceContext);
    }

    public void deleteCommerceWarehouse(long commerceWarehouseId) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehouseLocalService.getCommerceWarehouse(commerceWarehouseId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceWarehouse.getGroupId(), "MANAGE_COMMERCE_WAREHOUSES");
        this.commerceWarehouseLocalService.deleteCommerceWarehouse(commerceWarehouse);
    }

    public CommerceWarehouse fetchDefaultCommerceWarehouse(long groupId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.fetchDefaultCommerceWarehouse(groupId);
    }

    public CommerceWarehouse geolocateCommerceWarehouse(long commerceWarehouseId) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehouseLocalService.getCommerceWarehouse(commerceWarehouseId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceWarehouse.getGroupId(), "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.geolocateCommerceWarehouse(commerceWarehouse.getCommerceWarehouseId());
    }

    public CommerceWarehouse getCommerceWarehouse(long commerceWarehouseId) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehouseLocalService.getCommerceWarehouse(commerceWarehouseId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceWarehouse.getGroupId(), "MANAGE_COMMERCE_WAREHOUSES");
        return commerceWarehouse;
    }

    public List<CommerceWarehouse> getCommerceWarehouses(long groupId, boolean active, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.getCommerceWarehouses(groupId, active, start, end, orderByComparator);
    }

    public List<CommerceWarehouse> getCommerceWarehouses(long groupId, boolean active, long commerceCountryId, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.getCommerceWarehouses(groupId, active, commerceCountryId, start, end, orderByComparator);
    }

    public List<CommerceWarehouse> getCommerceWarehouses(long groupId, long commerceCountryId, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.getCommerceWarehouses(groupId, commerceCountryId, start, end, orderByComparator);
    }

    public int getCommerceWarehousesCount(long groupId, boolean active, long commerceCountryId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.getCommerceWarehousesCount(groupId, active, commerceCountryId);
    }

    public int getCommerceWarehousesCount(long groupId, long commerceCountryId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.getCommerceWarehousesCount(groupId, commerceCountryId);
    }

    public List<CommerceWarehouse> search(long groupId, String keywords, boolean all, long commerceCountryId, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.search(groupId, keywords, Boolean.valueOf(all), commerceCountryId, start, end, orderByComparator);
    }

    public int searchCount(long groupId, String keywords, Boolean active, long commerceCountryId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.searchCount(groupId, keywords, active, commerceCountryId);
    }

    public CommerceWarehouse setActive(long commerceWarehouseId, boolean active) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehouseLocalService.fetchCommerceWarehouse(commerceWarehouseId);
        if (commerceWarehouse != null) {
            _portletResourcePermission.check(this.getPermissionChecker(), commerceWarehouse.getGroupId(), "MANAGE_COMMERCE_WAREHOUSES");
        }
        return this.commerceWarehouseLocalService.setActive(commerceWarehouseId, active);
    }

    public CommerceWarehouse updateCommerceWarehouse(long commerceWarehouseId, String name, String description, boolean active, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.updateCommerceWarehouse(commerceWarehouseId, name, description, active, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, latitude, longitude, serviceContext);
    }

    public CommerceWarehouse updateDefaultCommerceWarehouse(String name, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COMMERCE_WAREHOUSES");
        return this.commerceWarehouseLocalService.updateDefaultCommerceWarehouse(name, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, latitude, longitude, serviceContext);
    }
}

