/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShipmentExpectedDateException;
import com.liferay.commerce.exception.CommerceShipmentShippingDateException;
import com.liferay.commerce.exception.CommerceShipmentStatusException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.base.CommerceShipmentLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class CommerceShipmentLocalServiceImpl
extends CommerceShipmentLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        long commerceShipmentId = this.counterLocalService.increment();
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.create(commerceShipmentId);
        commerceShipment.setGroupId(commerceOrder.getGroupId());
        commerceShipment.setCompanyId(user.getCompanyId());
        commerceShipment.setUserId(user.getUserId());
        commerceShipment.setUserName(user.getFullName());
        commerceShipment.setSiteGroupId(commerceOrder.getSiteGroupId());
        commerceShipment.setShipmentOrganizationId(commerceOrder.getOrderOrganizationId());
        commerceShipment.setShipmentUserId(commerceOrder.getOrderUserId());
        commerceShipment.setCommerceAddressId(commerceOrder.getShippingAddressId());
        commerceShipment.setCommerceShippingMethodId(commerceOrder.getCommerceShippingMethodId());
        commerceShipment.setShippingOptionName(commerceOrder.getShippingOptionName());
        commerceShipment.setStatus(0);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShipment deleteCommerceShipment(CommerceShipment commerceShipment) {
        this.commerceShipmentItemLocalService.deleteCommerceShipmentItems(commerceShipment.getCommerceShipmentId());
        this.commerceShipmentPersistence.remove((BaseModel)commerceShipment);
        return commerceShipment;
    }

    @Override
    public CommerceShipment deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        return this.commerceShipmentLocalService.deleteCommerceShipment(commerceShipment);
    }

    public List<CommerceShipment> getCommerceShipmentsByG_S(long groupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByG_S(groupId, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipmentsByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipmentsByS_S(long siteGroupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByS_S(siteGroupId, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipmentsBySiteGroupId(long siteGroupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findBySiteGroupId(siteGroupId, start, end, orderByComparator);
    }

    public int getCommerceShipmentsCountByG_S(long groupId, int status) {
        return this.commerceShipmentPersistence.countByG_S(groupId, status);
    }

    public int getCommerceShipmentsCountByGroupId(long groupId) {
        return this.commerceShipmentPersistence.countByGroupId(groupId);
    }

    public int getCommerceShipmentsCountByS_S(long siteGroupId, int status) {
        return this.commerceShipmentPersistence.countByS_S(siteGroupId, status);
    }

    public int getCommerceShipmentsCountBySiteGroupId(long siteGroupId) {
        return this.commerceShipmentPersistence.countBySiteGroupId(siteGroupId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        User user = this.userLocalService.getUser(commerceShipment.getUserId());
        int oldStatus = commerceShipment.getStatus();
        this.validate(status, oldStatus);
        Date shippingDate = PortalUtil.getDate((int)shippingDateMonth, (int)shippingDateDay, (int)shippingDateYear, (int)shippingDateHour, (int)shippingDateMinute, (TimeZone)user.getTimeZone(), CommerceShipmentShippingDateException.class);
        Date expectedDate = PortalUtil.getDate((int)expectedDateMonth, (int)expectedDateDay, (int)expectedDateYear, (int)expectedDateHour, (int)expectedDateMinute, (TimeZone)user.getTimeZone(), CommerceShipmentExpectedDateException.class);
        commerceShipment.setCarrier(carrier);
        commerceShipment.setTrackingNumber(trackingNumber);
        commerceShipment.setStatus(status);
        commerceShipment.setShippingDate(shippingDate);
        commerceShipment.setExpectedDate(expectedDate);
        this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
        this.updateCommerceOrderStatus(commerceShipment.getCommerceShipmentId(), status, oldStatus);
        return commerceShipment;
    }

    protected void updateCommerceOrderStatus(long commerceShipmentId, int status, int oldStatus) throws PortalException {
        if (status <= oldStatus) {
            return;
        }
        List commerceShipmentItems = this.commerceShipmentItemLocalService.getCommerceShipmentItems(commerceShipmentId, -1, -1, null);
        if (commerceShipmentItems.isEmpty()) {
            return;
        }
        CommerceShipmentItem commerceShipmentItem = (CommerceShipmentItem)commerceShipmentItems.get(0);
        CommerceOrderItem commerceOrderItem = commerceShipmentItem.fetchCommerceOrderItem();
        if (commerceOrderItem == null) {
            return;
        }
        long commerceOrderId = commerceOrderItem.getCommerceOrderId();
        List commerceOrderItems = this.commerceOrderItemLocalService.getAvailableForShipmentCommerceOrderItems(commerceOrderId);
        if (status == 1) {
            this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, 12);
        } else if (status == 2) {
            if (commerceOrderItems.isEmpty()) {
                this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, 15);
            } else {
                this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, 14);
            }
        } else if (status == 3 && commerceOrderItems.isEmpty()) {
            this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, 0);
        }
    }

    protected void validate(int status, int oldStatus) throws PortalException {
        if (status < oldStatus) {
            throw new CommerceShipmentStatusException();
        }
    }
}

