/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommercePaymentMethod;
import com.liferay.commerce.service.base.CommercePaymentMethodServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommercePaymentMethodServiceImpl
extends CommercePaymentMethodServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommercePaymentMethodServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public CommercePaymentMethod addCommercePaymentMethod(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, String engineKey, Map<String, String> engineParameterMap, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COMMERCE_PAYMENT_METHODS");
        return this.commercePaymentMethodLocalService.addCommercePaymentMethod(nameMap, descriptionMap, imageFile, engineKey, engineParameterMap, priority, active, serviceContext);
    }

    public CommercePaymentMethod createCommercePaymentMethod(long commercePaymentMethodId) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodLocalService.fetchCommercePaymentMethod(commercePaymentMethodId);
        if (commercePaymentMethod != null) {
            _portletResourcePermission.check(this.getPermissionChecker(), commercePaymentMethod.getGroupId(), "MANAGE_COMMERCE_PAYMENT_METHODS");
        }
        return this.commercePaymentMethodLocalService.createCommercePaymentMethod(commercePaymentMethodId);
    }

    public void deleteCommercePaymentMethod(long commercePaymentMethodId) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodLocalService.getCommercePaymentMethod(commercePaymentMethodId);
        _portletResourcePermission.check(this.getPermissionChecker(), commercePaymentMethod.getGroupId(), "MANAGE_COMMERCE_PAYMENT_METHODS");
        this.commercePaymentMethodLocalService.deleteCommercePaymentMethod(commercePaymentMethod);
    }

    public CommercePaymentMethod getCommercePaymentMethod(long commercePaymentMethodId) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodLocalService.getCommercePaymentMethod(commercePaymentMethodId);
        _portletResourcePermission.check(this.getPermissionChecker(), commercePaymentMethod.getGroupId(), "MANAGE_COMMERCE_PAYMENT_METHODS");
        return commercePaymentMethod;
    }

    public List<CommercePaymentMethod> getCommercePaymentMethods(long groupId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_PAYMENT_METHODS");
        return this.commercePaymentMethodLocalService.getCommercePaymentMethods(groupId);
    }

    public List<CommercePaymentMethod> getCommercePaymentMethods(long groupId, boolean active) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_PAYMENT_METHODS");
        return this.commercePaymentMethodLocalService.getCommercePaymentMethods(groupId, active);
    }

    public int getCommercePaymentMethodsCount(long groupId, boolean active) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_PAYMENT_METHODS");
        return this.commercePaymentMethodLocalService.getCommercePaymentMethodsCount(groupId, active);
    }

    public CommercePaymentMethod setActive(long commercePaymentMethodId, boolean active) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodLocalService.fetchCommercePaymentMethod(commercePaymentMethodId);
        if (commercePaymentMethod != null) {
            _portletResourcePermission.check(this.getPermissionChecker(), commercePaymentMethod.getGroupId(), "MANAGE_COMMERCE_PAYMENT_METHODS");
        }
        return this.commercePaymentMethodLocalService.setActive(commercePaymentMethodId, active);
    }

    public CommercePaymentMethod updateCommercePaymentMethod(long commercePaymentMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, Map<String, String> engineParameterMap, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodLocalService.getCommercePaymentMethod(commercePaymentMethodId);
        _portletResourcePermission.check(this.getPermissionChecker(), commercePaymentMethod.getGroupId(), "MANAGE_COMMERCE_PAYMENT_METHODS");
        return this.commercePaymentMethodLocalService.updateCommercePaymentMethod(commercePaymentMethod.getCommercePaymentMethodId(), nameMap, descriptionMap, imageFile, engineParameterMap, priority, active, serviceContext);
    }
}

