/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommercePaymentMethodEngineKeyException;
import com.liferay.commerce.exception.CommercePaymentMethodNameException;
import com.liferay.commerce.model.CommercePaymentEngine;
import com.liferay.commerce.model.CommercePaymentMethod;
import com.liferay.commerce.service.base.CommercePaymentMethodLocalServiceBaseImpl;
import com.liferay.commerce.util.CommercePaymentEngineRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommercePaymentMethodLocalServiceImpl
extends CommercePaymentMethodLocalServiceBaseImpl {
    @ServiceReference(type=CommercePaymentEngineRegistry.class)
    private CommercePaymentEngineRegistry _commercePaymentEngineRegistry;

    public CommercePaymentMethod addCommercePaymentMethod(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, String engineKey, Map<String, String> engineParameterMap, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        if (imageFile != null && !imageFile.exists()) {
            imageFile = null;
        }
        this.validate(nameMap, engineKey);
        long commercePaymentMethodId = this.counterLocalService.increment();
        CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodPersistence.create(commercePaymentMethodId);
        commercePaymentMethod.setGroupId(groupId);
        commercePaymentMethod.setCompanyId(user.getCompanyId());
        commercePaymentMethod.setUserId(user.getUserId());
        commercePaymentMethod.setUserName(user.getFullName());
        commercePaymentMethod.setNameMap(nameMap);
        commercePaymentMethod.setDescriptionMap(descriptionMap);
        if (imageFile != null) {
            commercePaymentMethod.setImageId(this.counterLocalService.increment());
        }
        commercePaymentMethod.setEngineKey(engineKey);
        commercePaymentMethod.setPriority(priority);
        commercePaymentMethod.setActive(active);
        this.commercePaymentMethodPersistence.update((BaseModel)commercePaymentMethod);
        if (imageFile != null) {
            this.imageLocalService.updateImage(commercePaymentMethod.getImageId(), imageFile);
        }
        this.updateCommercePaymentEngineConfiguration(engineKey, engineParameterMap, serviceContext);
        return commercePaymentMethod;
    }

    @Override
    public CommercePaymentMethod deleteCommercePaymentMethod(CommercePaymentMethod commercePaymentMethod) throws PortalException {
        this.commercePaymentMethodPersistence.remove((BaseModel)commercePaymentMethod);
        if (commercePaymentMethod.getImageId() > 0L) {
            this.imageLocalService.deleteImage(commercePaymentMethod.getImageId());
        }
        this.commerceAddressRestrictionLocalService.deleteCommerceAddressRestrictions(CommercePaymentMethod.class.getName(), commercePaymentMethod.getCommercePaymentMethodId());
        return commercePaymentMethod;
    }

    @Override
    public CommercePaymentMethod deleteCommercePaymentMethod(long commercePaymentMethodId) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodPersistence.findByPrimaryKey(commercePaymentMethodId);
        return this.commercePaymentMethodLocalService.deleteCommercePaymentMethod(commercePaymentMethod);
    }

    public void deleteCommercePaymentMethods(long groupId) throws PortalException {
        List commercePaymentMethods = this.commercePaymentMethodPersistence.findByGroupId(groupId);
        for (CommercePaymentMethod commercePaymentMethod : commercePaymentMethods) {
            this.commercePaymentMethodLocalService.deleteCommercePaymentMethod(commercePaymentMethod);
        }
    }

    public List<CommercePaymentMethod> getCommercePaymentMethods(long groupId) {
        return this.commercePaymentMethodPersistence.findByGroupId(groupId);
    }

    public List<CommercePaymentMethod> getCommercePaymentMethods(long groupId, boolean active) {
        return this.commercePaymentMethodPersistence.findByG_A(groupId, active);
    }

    public List<CommercePaymentMethod> getCommercePaymentMethods(long groupId, long commerceCountryId, boolean active) {
        ArrayList<CommercePaymentMethod> filteredCommercePaymentMethods = new ArrayList<CommercePaymentMethod>();
        List commercePaymentMethods = this.commercePaymentMethodPersistence.findByG_A(groupId, active);
        for (CommercePaymentMethod commercePaymentMethod : commercePaymentMethods) {
            boolean restricted = this.commerceAddressRestrictionLocalService.isCommercePaymentMethodRestricted(commercePaymentMethod.getCommercePaymentMethodId(), commerceCountryId);
            if (restricted) continue;
            filteredCommercePaymentMethods.add(commercePaymentMethod);
        }
        return filteredCommercePaymentMethods;
    }

    public int getCommercePaymentMethodsCount(long groupId, boolean active) {
        return this.commercePaymentMethodPersistence.countByG_A(groupId, active);
    }

    public CommercePaymentMethod setActive(long commercePaymentMethodId, boolean active) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodPersistence.findByPrimaryKey(commercePaymentMethodId);
        commercePaymentMethod.setActive(active);
        this.commercePaymentMethodPersistence.update((BaseModel)commercePaymentMethod);
        return commercePaymentMethod;
    }

    public CommercePaymentMethod updateCommercePaymentMethod(long commercePaymentMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, Map<String, String> engineParameterMap, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodPersistence.findByPrimaryKey(commercePaymentMethodId);
        if (imageFile != null && !imageFile.exists()) {
            imageFile = null;
        }
        commercePaymentMethod.setNameMap(nameMap);
        commercePaymentMethod.setDescriptionMap(descriptionMap);
        if (imageFile != null && commercePaymentMethod.getImageId() <= 0L) {
            commercePaymentMethod.setImageId(this.counterLocalService.increment());
        }
        commercePaymentMethod.setPriority(priority);
        commercePaymentMethod.setActive(active);
        this.commercePaymentMethodPersistence.update((BaseModel)commercePaymentMethod);
        if (imageFile != null) {
            this.imageLocalService.updateImage(commercePaymentMethod.getImageId(), imageFile);
        }
        this.updateCommercePaymentEngineConfiguration(commercePaymentMethod.getEngineKey(), engineParameterMap, serviceContext);
        return commercePaymentMethod;
    }

    protected void updateCommercePaymentEngineConfiguration(String key, Map<String, String> parameterMap, ServiceContext serviceContext) throws PortalException {
        CommercePaymentEngine commercePaymentEngine = this._commercePaymentEngineRegistry.getCommercePaymentEngine(key);
        try {
            commercePaymentEngine.updateConfiguration(parameterMap, serviceContext);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void validate(Map<Locale, String> nameMap, String engineKey) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new CommercePaymentMethodNameException();
        }
        if (Validator.isNull((String)engineKey)) {
            throw new CommercePaymentMethodEngineKeyException();
        }
    }
}

