/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.internal.security.permission.CommerceOrderWorkflowPermissionChecker;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.base.CommerceOrderServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.List;

public class CommerceOrderServiceImpl
extends CommerceOrderServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceOrderServiceImpl.class, (String)"_commerceOrderModelResourcePermission", CommerceOrder.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceOrderServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce.order");
    @ServiceReference(type=CommerceOrderWorkflowPermissionChecker.class)
    private CommerceOrderWorkflowPermissionChecker _commerceOrderWorkflowPermissionChecker;
    @ServiceReference(type=WorkflowTaskManager.class)
    private WorkflowTaskManager _workflowTaskManager;

    public CommerceOrder addOrganizationCommerceOrder(long groupId, long siteGroupId, long orderOrganizationId, long commerceCurrencyId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        _portletResourcePermission.contains(this.getPermissionChecker(), groupId, "ADD_COMMERCE_ORDER");
        return this.commerceOrderLocalService.addOrganizationCommerceOrder(groupId, this.getUserId(), siteGroupId, orderOrganizationId, commerceCurrencyId, shippingAddressId, purchaseOrderNumber);
    }

    public CommerceOrder addOrganizationCommerceOrder(long groupId, long siteGroupId, long orderOrganizationId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        _portletResourcePermission.contains(this.getPermissionChecker(), groupId, "ADD_COMMERCE_ORDER");
        return this.commerceOrderLocalService.addOrganizationCommerceOrder(groupId, this.getUserId(), siteGroupId, orderOrganizationId, shippingAddressId, purchaseOrderNumber);
    }

    public CommerceOrder approveCommerceOrder(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "APPROVE_COMMERCE_ORDER");
        return this.commerceOrderLocalService.approveCommerceOrder(this.getUserId(), commerceOrderId);
    }

    public CommerceOrder cancelCommerceOrderPayment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "CHECKOUT_COMMERCE_ORDER");
        return this.commerceOrderLocalService.cancelCommerceOrderPayment(commerceOrderId, serviceContext);
    }

    public CommerceOrder checkoutCommerceOrder(long commerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "CHECKOUT_COMMERCE_ORDER");
        return this.commerceOrderLocalService.checkoutCommerceOrder(commerceOrderId, commerceContext, serviceContext);
    }

    public CommerceOrder completeCommerceOrderPayment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "CHECKOUT_COMMERCE_ORDER");
        return this.commerceOrderLocalService.completeCommerceOrderPayment(commerceOrderId, serviceContext);
    }

    public void deleteCommerceOrder(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "DELETE");
        this.commerceOrderLocalService.deleteCommerceOrder(commerceOrderId);
    }

    public CommerceOrder executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        WorkflowTask workflowTask;
        CommerceOrder commerceOrder = this.getCommerceOrder(commerceOrderId);
        if (!this._commerceOrderWorkflowPermissionChecker.hasPermission(commerceOrder, workflowTask = this._workflowTaskManager.getWorkflowTask(commerceOrder.getCompanyId(), workflowTaskId), this.getPermissionChecker())) {
            throw new PrincipalException();
        }
        return this.commerceOrderLocalService.executeWorkflowTransition(this.getUserId(), commerceOrderId, workflowTaskId, transitionName, comment);
    }

    public CommerceOrder fetchCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(commerceOrderId);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(long groupId, int orderStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(groupId, this.getGuestOrUserId(), orderStatus);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(String uuid, long groupId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(uuid, groupId);
        if (commerceOrder != null) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public int[] getAvailableOrderStatuses(long commerceOrderId) throws PortalException {
        if (commerceOrderId > 0L) {
            _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        }
        return this.commerceOrderLocalService.getAvailableOrderStatuses(commerceOrderId);
    }

    public CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        return commerceOrder;
    }

    public CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        return commerceOrder;
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        _portletResourcePermission.contains(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long siteGroupId, int[] orderStatuses) throws PortalException {
        _portletResourcePermission.contains(this.getPermissionChecker(), siteGroupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(siteGroupId, orderStatuses);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, long orderUserId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (orderUserId != permissionChecker.getUserId() && !_portletResourcePermission.contains(permissionChecker, groupId, "MANAGE_COMMERCE_ORDERS")) {
            throw new PrincipalException();
        }
        return this.commerceOrderLocalService.getCommerceOrders(groupId, orderUserId, start, end, orderByComparator);
    }

    public int getCommerceOrdersCount(long groupId) throws PortalException {
        _portletResourcePermission.contains(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrdersCount(groupId);
    }

    public int getCommerceOrdersCount(long groupId, long orderUserId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (orderUserId != permissionChecker.getUserId() && !_portletResourcePermission.contains(permissionChecker, groupId, "MANAGE_COMMERCE_ORDERS")) {
            throw new PrincipalException();
        }
        return this.commerceOrderLocalService.getCommerceOrdersCount(groupId, orderUserId);
    }

    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), guestCommerceOrderId, "VIEW");
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), userCommerceOrderId, "UPDATE");
        this.commerceOrderLocalService.mergeGuestCommerceOrder(guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    public CommerceOrder reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderLocalService.reorderCommerceOrder(this.getUserId(), commerceOrderId, commerceContext);
    }

    public String startCommerceOrderPayment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "CHECKOUT_COMMERCE_ORDER");
        return this.commerceOrderLocalService.startCommerceOrderPayment(commerceOrderId, serviceContext);
    }

    public CommerceOrder submitCommerceOrder(long commerceOrderId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.submitCommerceOrder(this.getUserId(), commerceOrderId);
    }

    public CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateBillingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    public CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, long commercePaymentMethodId, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, CommerceContext commerceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodId, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, commerceContext);
    }

    public CommerceOrder updateOrderStatus(long commerceOrderId, int orderStatus) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateOrderStatus(commerceOrderId, orderStatus);
    }

    public CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updatePaymentStatus(commerceOrderId, paymentStatus, serviceContext);
    }

    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    public CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateShippingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    public CommerceOrder updateUser(long commerceOrderId, long userId) throws PortalException {
        _commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateUser(commerceOrderId, userId);
    }
}

