/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceCountryNameException;
import com.liferay.commerce.exception.CommerceCountryThreeLettersISOCodeException;
import com.liferay.commerce.exception.CommerceCountryTwoLettersISOCodeException;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.service.base.CommerceCountryLocalServiceBaseImpl;
import com.liferay.commerce.starter.CommerceRegionsStarter;
import com.liferay.commerce.starter.CommerceRegionsStarterRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceCountryLocalServiceImpl
extends CommerceCountryLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    @ServiceReference(type=CommerceRegionsStarterRegistry.class)
    private CommerceRegionsStarterRegistry _commerceRegionsStarterRegistry;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceCountry addCommerceCountry(Map<Locale, String> nameMap, boolean billingAllowed, boolean shippingAllowed, String twoLettersISOCode, String threeLettersISOCode, int numericISOCode, boolean subjectToVAT, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        this.validate(nameMap, twoLettersISOCode, threeLettersISOCode);
        long commerceCountryId = this.counterLocalService.increment();
        CommerceCountry commerceCountry = this.commerceCountryPersistence.create(commerceCountryId);
        commerceCountry.setUuid(serviceContext.getUuid());
        commerceCountry.setGroupId(groupId);
        commerceCountry.setCompanyId(user.getCompanyId());
        commerceCountry.setUserId(user.getUserId());
        commerceCountry.setUserName(user.getFullName());
        commerceCountry.setNameMap(nameMap);
        commerceCountry.setBillingAllowed(billingAllowed);
        commerceCountry.setShippingAllowed(shippingAllowed);
        commerceCountry.setTwoLettersISOCode(twoLettersISOCode);
        commerceCountry.setThreeLettersISOCode(threeLettersISOCode);
        commerceCountry.setNumericISOCode(numericISOCode);
        commerceCountry.setSubjectToVAT(subjectToVAT);
        commerceCountry.setPriority(priority);
        commerceCountry.setActive(active);
        this.commerceCountryPersistence.update((BaseModel)commerceCountry);
        return commerceCountry;
    }

    public void deleteCommerceCountries(long groupId) throws PortalException {
        List commerceCountries = this.commerceCountryPersistence.findByGroupId(groupId);
        for (CommerceCountry commerceCountry : commerceCountries) {
            this.commerceCountryLocalService.deleteCommerceCountry(commerceCountry);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceCountry deleteCommerceCountry(CommerceCountry commerceCountry) throws PortalException {
        this.commerceCountryPersistence.remove((BaseModel)commerceCountry);
        this.commerceRegionLocalService.deleteCommerceRegions(commerceCountry.getCommerceCountryId());
        this.commerceAddressLocalService.deleteCountryCommerceAddresses(commerceCountry.getCommerceCountryId());
        this.commerceAddressRestrictionLocalService.deleteCommerceAddressRestrictions(commerceCountry.getCommerceCountryId());
        return commerceCountry;
    }

    @Override
    public CommerceCountry deleteCommerceCountry(long commerceCountryId) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryPersistence.findByPrimaryKey(commerceCountryId);
        return this.commerceCountryLocalService.deleteCommerceCountry(commerceCountry);
    }

    public CommerceCountry fetchCommerceCountry(long groupId, int numericISOCode) throws PortalException {
        return this.commerceCountryPersistence.fetchByG_N(groupId, numericISOCode);
    }

    public List<CommerceCountry> getBillingCommerceCountries(long groupId, boolean billingAllowed, boolean active) {
        return this.commerceCountryPersistence.findByG_B_A(groupId, billingAllowed, active);
    }

    public List<CommerceCountry> getCommerceCountries(long groupId, boolean active) {
        return this.commerceCountryPersistence.findByG_A(groupId, active);
    }

    public List<CommerceCountry> getCommerceCountries(long groupId, boolean active, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) {
        return this.commerceCountryPersistence.findByG_A(groupId, active, start, end, orderByComparator);
    }

    public List<CommerceCountry> getCommerceCountries(long groupId, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) {
        return this.commerceCountryPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public int getCommerceCountriesCount(long groupId) {
        return this.commerceCountryPersistence.countByGroupId(groupId);
    }

    public int getCommerceCountriesCount(long groupId, boolean active) {
        return this.commerceCountryPersistence.countByG_A(groupId, active);
    }

    public List<CommerceCountry> getShippingCommerceCountries(long groupId, boolean shippingAllowed, boolean active) {
        return this.commerceCountryPersistence.findByG_S_A(groupId, shippingAllowed, active);
    }

    public List<CommerceCountry> getWarehouseCommerceCountries(long groupId, boolean all) {
        return this.commerceCountryFinder.findByCommerceWarehouses(groupId, all);
    }

    public void importDefaultCountries(ServiceContext serviceContext) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String countriesPath = "com/liferay/commerce/internal/countries.json";
        String countriesJSON = StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)countriesPath, (boolean)false);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)countriesJSON);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String name = jsonObject.getString("name");
            int numericISOCode = jsonObject.getInt("numericISOCode");
            double priority = jsonObject.getDouble("priority");
            String threeLettersISOCode = jsonObject.getString("threeLettersISOCode");
            String twoLettersISOCode = jsonObject.getString("twoLettersISOCode");
            String localizedName = LanguageUtil.get((Locale)serviceContext.getLocale(), (String)("country." + name));
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            nameMap.put(serviceContext.getLocale(), localizedName);
            this.commerceCountryLocalService.addCommerceCountry(nameMap, true, true, twoLettersISOCode, threeLettersISOCode, numericISOCode, false, priority, true, serviceContext);
            CommerceRegionsStarter commerceRegionsStarter = this._commerceRegionsStarterRegistry.getCommerceRegionsStarter(String.valueOf(numericISOCode));
            if (commerceRegionsStarter == null) continue;
            commerceRegionsStarter.start(serviceContext);
        }
    }

    public BaseModelSearchResult<CommerceCountry> searchCommerceCountries(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceCountry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceCountry> commerceCountries = this.getCommerceCountries(hits);
            if (commerceCountries == null) continue;
            return new BaseModelSearchResult(commerceCountries, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public CommerceCountry setActive(long commerceCountryId, boolean active) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryPersistence.findByPrimaryKey(commerceCountryId);
        commerceCountry.setActive(active);
        this.commerceCountryPersistence.update((BaseModel)commerceCountry);
        return commerceCountry;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceCountry updateCommerceCountry(long commerceCountryId, Map<Locale, String> nameMap, boolean billingAllowed, boolean shippingAllowed, String twoLettersISOCode, String threeLettersISOCode, int numericISOCode, boolean subjectToVAT, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryPersistence.findByPrimaryKey(commerceCountryId);
        this.validate(nameMap, twoLettersISOCode, threeLettersISOCode);
        commerceCountry.setNameMap(nameMap);
        commerceCountry.setBillingAllowed(billingAllowed);
        commerceCountry.setShippingAllowed(shippingAllowed);
        commerceCountry.setTwoLettersISOCode(twoLettersISOCode);
        commerceCountry.setThreeLettersISOCode(threeLettersISOCode);
        commerceCountry.setNumericISOCode(numericISOCode);
        commerceCountry.setSubjectToVAT(subjectToVAT);
        commerceCountry.setPriority(priority);
        commerceCountry.setActive(active);
        this.commerceCountryPersistence.update((BaseModel)commerceCountry);
        return commerceCountry;
    }

    protected List<CommerceCountry> getCommerceCountries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceCountry> commerceCountries = new ArrayList<CommerceCountry>(documents.size());
        for (Document document : documents) {
            long commerceCountryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceCountry commerceCountry = this.fetchCommerceCountry(commerceCountryId);
            if (commerceCountry == null) {
                commerceCountries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceCountry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceCountries == null) continue;
            commerceCountries.add(commerceCountry);
        }
        return commerceCountries;
    }

    protected void validate(Map<Locale, String> nameMap, String twoLettersISOCode, String threeLettersISOCode) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new CommerceCountryNameException();
        }
        if (Validator.isNotNull((String)twoLettersISOCode) && twoLettersISOCode.length() != 2) {
            throw new CommerceCountryTwoLettersISOCodeException();
        }
        if (Validator.isNotNull((String)threeLettersISOCode) && threeLettersISOCode.length() != 3) {
            throw new CommerceCountryThreeLettersISOCodeException();
        }
    }
}

