/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.model.CommercePaymentMethod;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.service.base.CommerceAddressRestrictionServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceAddressRestrictionServiceImpl
extends CommerceAddressRestrictionServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceAddressRestrictionServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public CommerceAddressRestriction addCommerceAddressRestriction(String className, long classPK, long commerceCountryId, ServiceContext serviceContext) throws PortalException {
        this.checkModel(className, classPK);
        return this.commerceAddressRestrictionLocalService.addCommerceAddressRestriction(className, classPK, commerceCountryId, serviceContext);
    }

    public void deleteCommerceAddressRestriction(long commerceAddressRestrictionId) throws PortalException {
        CommerceAddressRestriction commerceAddressRestriction = this.commerceAddressRestrictionLocalService.getCommerceAddressRestriction(commerceAddressRestrictionId);
        this.checkModel(commerceAddressRestriction.getClassName(), commerceAddressRestriction.getClassPK());
        this.commerceAddressRestrictionLocalService.deleteCommerceAddressRestriction(commerceAddressRestrictionId);
    }

    public List<CommerceAddressRestriction> getCommerceAddressRestrictions(String className, long classPK, int start, int end, OrderByComparator<CommerceAddressRestriction> orderByComparator) throws PortalException {
        this.checkModel(className, classPK);
        return this.commerceAddressRestrictionLocalService.getCommerceAddressRestrictions(className, classPK, start, end, orderByComparator);
    }

    public int getCommerceAddressRestrictionsCount(String className, long classPK) throws PortalException {
        this.checkModel(className, classPK);
        return this.commerceAddressRestrictionLocalService.getCommerceAddressRestrictionsCount(className, classPK);
    }

    public boolean isCommerceShippingMethodRestricted(long commerceShippingMethodId, long commerceCountryId) throws PortalException {
        this.checkModel(CommerceShippingMethod.class.getName(), commerceShippingMethodId);
        return this.commerceAddressRestrictionLocalService.isCommerceShippingMethodRestricted(commerceShippingMethodId, commerceCountryId);
    }

    protected void checkModel(String className, long classPK) throws PortalException {
        if (className.equals(CommercePaymentMethod.class.getName())) {
            CommercePaymentMethod commercePaymentMethod = this.commercePaymentMethodLocalService.getCommercePaymentMethod(classPK);
            _portletResourcePermission.check(this.getPermissionChecker(), commercePaymentMethod.getGroupId(), "MANAGE_COMMERCE_SHIPPING_METHODS");
        } else if (className.equals(CommerceShippingMethod.class.getName())) {
            CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(classPK);
            _portletResourcePermission.check(this.getPermissionChecker(), commerceShippingMethod.getGroupId(), "MANAGE_COMMERCE_PAYMENT_METHODS");
        }
    }
}

