/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.model.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactoryUtil;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalServiceUtil;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommercePaymentMethod;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.impl.CommerceOrderBaseImpl;
import com.liferay.commerce.organization.service.CommerceOrganizationLocalServiceUtil;
import com.liferay.commerce.service.CommerceAddressLocalServiceUtil;
import com.liferay.commerce.service.CommerceOrderItemLocalServiceUtil;
import com.liferay.commerce.service.CommercePaymentMethodLocalServiceUtil;
import com.liferay.commerce.service.CommerceShippingMethodLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import java.math.BigDecimal;
import java.util.List;

@ProviderType
public class CommerceOrderImpl
extends CommerceOrderBaseImpl {
    public CommerceAddress getBillingAddress() throws PortalException {
        long billingAddressId = this.getBillingAddressId();
        if (billingAddressId > 0L) {
            return CommerceAddressLocalServiceUtil.getCommerceAddress((long)this.getBillingAddressId());
        }
        return null;
    }

    public String getClassName() throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
        if (group.isOrganization() && CommerceOrganizationLocalServiceUtil.isB2BOrganization((long)group.getOrganizationId())) {
            return Organization.class.getName();
        }
        return User.class.getName();
    }

    public long getClassPK() throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
        if (group.isOrganization() && CommerceOrganizationLocalServiceUtil.isB2BOrganization((long)group.getOrganizationId())) {
            return group.getOrganizationId();
        }
        return this.getOrderUserId();
    }

    public CommerceCurrency getCommerceCurrency() throws PortalException {
        return CommerceCurrencyLocalServiceUtil.getCommerceCurrency((long)this.getCommerceCurrencyId());
    }

    public List<CommerceOrderItem> getCommerceOrderItems() {
        return CommerceOrderItemLocalServiceUtil.getCommerceOrderItems((long)this.getCommerceOrderId(), (int)-1, (int)-1);
    }

    public CommercePaymentMethod getCommercePaymentMethod() throws PortalException {
        long commercePaymentMethodId = this.getCommercePaymentMethodId();
        if (commercePaymentMethodId > 0L) {
            return CommercePaymentMethodLocalServiceUtil.getCommercePaymentMethod((long)commercePaymentMethodId);
        }
        return null;
    }

    public CommerceShippingMethod getCommerceShippingMethod() throws PortalException {
        long commerceShippingMethodId = this.getCommerceShippingMethodId();
        if (commerceShippingMethodId > 0L) {
            return CommerceShippingMethodLocalServiceUtil.getCommerceShippingMethod((long)commerceShippingMethodId);
        }
        return null;
    }

    public long getCustomerId() {
        long customerId = this.getOrderOrganizationId();
        if (customerId <= 0L) {
            customerId = this.getOrderUserId();
        }
        return customerId;
    }

    public String getCustomerName() throws PortalException {
        Organization organization = this.getOrderOrganization();
        if (organization != null) {
            return organization.getName();
        }
        User orderUser = this.getOrderUser();
        if (orderUser.isDefaultUser()) {
            return "Guest";
        }
        return orderUser.getFullName();
    }

    public Organization getOrderOrganization() throws PortalException {
        long orderOrganizationId = this.getOrderOrganizationId();
        if (orderOrganizationId <= 0L) {
            return null;
        }
        return OrganizationLocalServiceUtil.getOrganization((long)orderOrganizationId);
    }

    public User getOrderUser() throws PortalException {
        long orderUserId = this.getOrderUserId();
        if (orderUserId <= 0L) {
            return null;
        }
        return UserLocalServiceUtil.getUser((long)orderUserId);
    }

    public CommerceAddress getShippingAddress() throws PortalException {
        long shippingAddressId = this.getShippingAddressId();
        if (shippingAddressId > 0L) {
            return CommerceAddressLocalServiceUtil.getCommerceAddress((long)this.getShippingAddressId());
        }
        return null;
    }

    public CommerceMoney getShippingMoney() throws PortalException {
        return CommerceMoneyFactoryUtil.create((long)this.getCommerceCurrencyId(), (BigDecimal)this.getShippingAmount());
    }

    public CommerceMoney getSubtotalMoney() throws PortalException {
        return CommerceMoneyFactoryUtil.create((long)this.getCommerceCurrencyId(), (BigDecimal)this.getSubtotal());
    }

    public CommerceMoney getTotalMoney() throws PortalException {
        return CommerceMoneyFactoryUtil.create((long)this.getCommerceCurrencyId(), (BigDecimal)this.getTotal());
    }

    public boolean isB2B() throws PortalException {
        String className = this.getClassName();
        return className.equals(Organization.class.getName());
    }

    public boolean isEmpty() {
        return CommerceOrderItemLocalServiceUtil.getCommerceOrderItemsCount((long)this.getCommerceOrderId()) <= 0;
    }

    public boolean isGuestOrder() throws PortalException {
        User orderUser = this.getOrderUser();
        return orderUser != null && orderUser.isDefaultUser();
    }

    public boolean isOpen() {
        return this.getOrderStatus() == 2;
    }

    public void setShippingDiscounts(CommerceDiscountValue commerceDiscountValue) {
        BigDecimal shippingDiscountAmount = BigDecimal.ZERO;
        BigDecimal shippingDiscountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal shippingDiscountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal shippingDiscountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal shippingDiscountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmount = commerceDiscountValue.getDiscountAmount();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            shippingDiscountAmount = discountAmount.getPrice();
            if (percentages != null && percentages.length > 0) {
                shippingDiscountPercentageLevel1 = percentages[0];
            }
            if (percentages != null && percentages.length > 1) {
                shippingDiscountPercentageLevel1 = percentages[1];
            }
            if (percentages != null && percentages.length > 2) {
                shippingDiscountPercentageLevel1 = percentages[2];
            }
            if (percentages != null && percentages.length > 3) {
                shippingDiscountPercentageLevel1 = percentages[3];
            }
        }
        this.setShippingDiscountAmount(shippingDiscountAmount);
        this.setShippingDiscountPercentageLevel1(shippingDiscountPercentageLevel1);
        this.setShippingDiscountPercentageLevel2(shippingDiscountPercentageLevel2);
        this.setShippingDiscountPercentageLevel3(shippingDiscountPercentageLevel3);
        this.setShippingDiscountPercentageLevel4(shippingDiscountPercentageLevel4);
    }

    public void setSubtotalDiscounts(CommerceDiscountValue commerceDiscountValue) {
        BigDecimal subtotalDiscountAmount = BigDecimal.ZERO;
        BigDecimal subtotalDiscountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal subtotalDiscountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal subtotalDiscountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal subtotalDiscountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmount = commerceDiscountValue.getDiscountAmount();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            subtotalDiscountAmount = discountAmount.getPrice();
            if (percentages != null && percentages.length > 0) {
                subtotalDiscountPercentageLevel1 = percentages[0];
            }
            if (percentages != null && percentages.length > 1) {
                subtotalDiscountPercentageLevel1 = percentages[1];
            }
            if (percentages != null && percentages.length > 2) {
                subtotalDiscountPercentageLevel1 = percentages[2];
            }
            if (percentages != null && percentages.length > 3) {
                subtotalDiscountPercentageLevel1 = percentages[3];
            }
        }
        this.setSubtotalDiscountAmount(subtotalDiscountAmount);
        this.setSubtotalDiscountPercentageLevel1(subtotalDiscountPercentageLevel1);
        this.setSubtotalDiscountPercentageLevel2(subtotalDiscountPercentageLevel2);
        this.setSubtotalDiscountPercentageLevel3(subtotalDiscountPercentageLevel3);
        this.setSubtotalDiscountPercentageLevel4(subtotalDiscountPercentageLevel4);
    }

    public void setTotalDiscounts(CommerceDiscountValue commerceDiscountValue) {
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        BigDecimal totalDiscountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal totalDiscountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal totalDiscountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal totalDiscountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmount = commerceDiscountValue.getDiscountAmount();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            totalDiscountAmount = discountAmount.getPrice();
            if (percentages != null && percentages.length > 0) {
                totalDiscountPercentageLevel1 = percentages[0];
            }
            if (percentages != null && percentages.length > 1) {
                totalDiscountPercentageLevel1 = percentages[1];
            }
            if (percentages != null && percentages.length > 2) {
                totalDiscountPercentageLevel1 = percentages[2];
            }
            if (percentages != null && percentages.length > 3) {
                totalDiscountPercentageLevel1 = percentages[3];
            }
        }
        this.setTotalDiscountAmount(totalDiscountAmount);
        this.setTotalDiscountPercentageLevel1(totalDiscountPercentageLevel1);
        this.setTotalDiscountPercentageLevel2(totalDiscountPercentageLevel2);
        this.setTotalDiscountPercentageLevel3(totalDiscountPercentageLevel3);
        this.setTotalDiscountPercentageLevel4(totalDiscountPercentageLevel4);
    }
}

