/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.servlet;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.path=/commerce-payment", "osgi.http.whiteboard.servlet.name=com.liferay.commerce.internal.servlet.CommercePaymentServlet", "osgi.http.whiteboard.servlet.pattern=/commerce-payment/*"}, service={Servlet.class})
public class CommercePaymentServlet
extends HttpServlet {
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private Portal _portal;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            HttpSession httpSession = httpServletRequest.getSession();
            if (PortalSessionThreadLocal.getHttpSession() == null) {
                PortalSessionThreadLocal.setHttpSession((HttpSession)httpSession);
            }
            User user = this._portal.getUser(httpServletRequest);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            boolean cancel = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"cancel");
            String redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            String uuid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"uuid");
            CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
            if (cancel) {
                this._commerceOrderService.cancelCommerceOrderPayment(commerceOrder.getCommerceOrderId(), serviceContext);
            } else {
                this._commerceOrderService.completeCommerceOrderPayment(commerceOrder.getCommerceOrderId(), serviceContext);
            }
            httpServletResponse.sendRedirect(redirect);
        }
        catch (Exception e) {
            this._portal.sendError(e, httpServletRequest, httpServletResponse);
        }
    }
}

