/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.security.permission;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskAssignee;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceOrderWorkflowPermissionChecker.class})
public class CommerceOrderWorkflowPermissionChecker {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderWorkflowPermissionChecker.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;

    public boolean hasPermission(CommerceOrder commerceOrder, WorkflowTask workflowTask, PermissionChecker permissionChecker) {
        if (permissionChecker.isOmniadmin() || permissionChecker.isCompanyAdmin()) {
            return true;
        }
        long[] roleIds = this._getRoleIds(commerceOrder.getGroupId(), permissionChecker);
        for (WorkflowTaskAssignee workflowTaskAssignee : workflowTask.getWorkflowTaskAssignees()) {
            if (!this._isWorkflowTaskAssignableToRoles(workflowTaskAssignee, roleIds) && !this._isWorkflowTaskAssignableToUser(workflowTaskAssignee, permissionChecker.getUserId())) continue;
            return true;
        }
        return false;
    }

    private List<Group> _getAncestorGroups(Group group) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group ancestorGroup : group.getAncestors()) {
            groups.add(ancestorGroup);
        }
        return groups;
    }

    private List<Group> _getAncestorOrganizationGroups(Group group) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>();
        Organization organization = this._organizationLocalService.getOrganization(group.getClassPK());
        for (Organization ancestorOrganization : organization.getAncestors()) {
            groups.add(ancestorOrganization.getGroup());
        }
        return groups;
    }

    private long[] _getRoleIds(long groupId, PermissionChecker permissionChecker) {
        long[] roleIds = permissionChecker.getRoleIds(permissionChecker.getUserId(), groupId);
        try {
            ArrayList<Group> groups = new ArrayList<Group>();
            if (groupId != 0L) {
                Group group = this._groupLocalService.getGroup(groupId);
                if (group.isOrganization()) {
                    groups.addAll(this._getAncestorOrganizationGroups(group));
                }
                if (group.isSite()) {
                    groups.addAll(this._getAncestorGroups(group));
                }
            }
            for (Group group : groups) {
                long[] roleIdArray = permissionChecker.getRoleIds(permissionChecker.getUserId(), group.getGroupId());
                roleIds = ArrayUtil.append((long[][])new long[][]{roleIds, roleIdArray});
            }
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        return roleIds;
    }

    private boolean _isWorkflowTaskAssignableToRoles(WorkflowTaskAssignee workflowTaskAssignee, long[] roleIds) {
        String assigneeClassName = workflowTaskAssignee.getAssigneeClassName();
        if (!assigneeClassName.equals(Role.class.getName())) {
            return false;
        }
        return ArrayUtil.contains((long[])roleIds, (long)workflowTaskAssignee.getAssigneeClassPK());
    }

    private boolean _isWorkflowTaskAssignableToUser(WorkflowTaskAssignee workflowTaskAssignee, long userId) {
        String assigneeClassName = workflowTaskAssignee.getAssigneeClassName();
        if (!assigneeClassName.equals(User.class.getName())) {
            return false;
        }
        return workflowTaskAssignee.getAssigneeClassPK() == userId;
    }
}

