/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommerceAddressIndexer
extends BaseIndexer<CommerceAddress> {
    public static final String CLASS_NAME = CommerceAddress.class.getName();
    public static final String FIELD_CITY = "city";
    public static final String FIELD_COUNTRY_NAME = "countryName";
    public static final String FIELD_REGION_NAME = "regionName";
    public static final String FIELD_ZIP = "zip";
    private static final Log _log = LogFactoryUtil.getLog(CommerceAddressIndexer.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommerceAddressIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "groupId", "modified", "name", "scopeGroupId", "uid"});
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long classPK;
        long classNameId = GetterUtil.getLong((Object)searchContext.getAttribute("classNameId"));
        if (classNameId > 0L) {
            contextBooleanFilter.addTerm("classNameId", String.valueOf(classNameId), BooleanClauseOccur.MUST);
        }
        if ((classPK = GetterUtil.getLong((Object)searchContext.getAttribute("classPK"))) > 0L) {
            contextBooleanFilter.addTerm("classPK", String.valueOf(classPK), BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, FIELD_CITY, false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_COUNTRY_NAME, false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_REGION_NAME, false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_ZIP, false);
    }

    protected void doDelete(CommerceAddress commerceAddress) throws Exception {
        this.deleteDocument(commerceAddress.getCompanyId(), commerceAddress.getCommerceAddressId());
    }

    protected Document doGetDocument(CommerceAddress commerceAddress) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing commerce address " + commerceAddress));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceAddress);
        document.addText(FIELD_CITY, commerceAddress.getCity());
        document.addText("name", commerceAddress.getName());
        document.addNumber(FIELD_ZIP, commerceAddress.getZip());
        CommerceCountry commerceCountry = commerceAddress.getCommerceCountry();
        document.addText(FIELD_COUNTRY_NAME, commerceCountry.getName());
        CommerceRegion commerceRegion = commerceAddress.getCommerceRegion();
        document.addText(FIELD_REGION_NAME, commerceRegion.getName());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceAddress + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceAddress commerceAddress) throws Exception {
        Document document = this.getDocument(commerceAddress);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceAddress.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressLocalService.getCommerceAddress(classPK);
        this.doReindex(commerceAddress);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceAddresses(companyId);
    }

    protected void reindexCommerceAddresses(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceAddressLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<CommerceAddress>(){

            public void performAction(CommerceAddress commerceAddress) {
                block2: {
                    try {
                        Document document = CommerceAddressIndexer.this.getDocument(commerceAddress);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index commerce address " + commerceAddress.getCommerceAddressId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

