/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.notification.type;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.notification.type.CommerceNotificationType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"commerce.notification.type.key=order-placed", "commerce.notification.type.order:Integer=10"}, service={CommerceNotificationType.class})
public class OrderPlacedCommerceNotificationTypeImpl
implements CommerceNotificationType {
    public static final String KEY = "order-placed";
    private static final String _ORDER_CREATOR = "[%ORDER_CREATOR%]";
    private static final String _ORDER_ID = "[%ORDER_ID%]";

    public Map<String, String> getDefinitionTerms(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        map.put(_ORDER_CREATOR, LanguageUtil.get((ResourceBundle)resourceBundle, (String)"order-creator-definition-term"));
        map.put(_ORDER_ID, LanguageUtil.get((ResourceBundle)resourceBundle, (String)"order-id-definition-term"));
        return map;
    }

    public String getFilledTerm(String term, Object object, Locale locale) throws PortalException {
        if (!(object instanceof CommerceOrder)) {
            return term;
        }
        CommerceOrder commerceOrder = (CommerceOrder)object;
        if (term.equals(_ORDER_CREATOR)) {
            Organization organization = commerceOrder.getOrderOrganization();
            if (organization != null) {
                return organization.getName();
            }
            User user = commerceOrder.getOrderUser();
            return user.getFullName(true, true);
        }
        if (term.equals(_ORDER_ID)) {
            return String.valueOf(commerceOrder.getCommerceOrderId());
        }
        return term;
    }

    public String getKey() {
        return KEY;
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)KEY);
    }
}

