/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.inventory;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.model.CommerceWarehouseItem;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.service.CPDAvailabilityEstimateLocalService;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceWarehouseItemLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"cp.definition.inventory.engine.key=default", "cp.definition.inventory.engine.priority:Integer=1"}, service={CPDefinitionInventoryEngine.class})
public class CPDefinitionInventoryEngineImpl
implements CPDefinitionInventoryEngine {
    public static final String KEY = "default";
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceWarehouseItemLocalService _commerceWarehouseItemLocalService;
    @Reference
    private CPDAvailabilityEstimateLocalService _cpdAvailabilityEstimateLocalService;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;

    public String[] getAllowedOrderQuantities(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return new String[0];
        }
        return StringUtil.split((String)cpDefinitionInventory.getAllowedOrderQuantities());
    }

    public String getAvailabilityEstimate(CPInstance cpInstance, Locale locale) throws PortalException {
        CPDAvailabilityEstimate cpDefinitionAvailabilityEstimate = this._cpdAvailabilityEstimateLocalService.fetchCPDAvailabilityEstimateByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionAvailabilityEstimate == null) {
            return "";
        }
        CommerceAvailabilityEstimate commerceAvailabilityEstimate = cpDefinitionAvailabilityEstimate.getCommerceAvailabilityEstimate();
        if (commerceAvailabilityEstimate == null) {
            return "";
        }
        return commerceAvailabilityEstimate.getTitle(locale);
    }

    public String getKey() {
        return KEY;
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)KEY);
    }

    public int getMaxOrderQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return 10000;
        }
        return cpDefinitionInventory.getMaxOrderQuantity();
    }

    public int getMinOrderQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return 1;
        }
        return cpDefinitionInventory.getMinOrderQuantity();
    }

    public int getMinStockQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return 0;
        }
        return cpDefinitionInventory.getMinStockQuantity();
    }

    public int getMultipleOrderQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return 1;
        }
        return cpDefinitionInventory.getMultipleOrderQuantity();
    }

    public int getStockQuantity(CPInstance cpInstance) {
        int warehouseCPInstanceQuantity = this._commerceWarehouseItemLocalService.getCPInstanceQuantity(cpInstance.getCPInstanceId());
        int orderCPInstanceQuantity = this._commerceOrderItemLocalService.getCPInstanceQuantity(cpInstance.getCPInstanceId(), 0);
        return warehouseCPInstanceQuantity - orderCPInstanceQuantity;
    }

    public boolean isBackOrderAllowed(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return false;
        }
        return cpDefinitionInventory.getBackOrders();
    }

    public boolean isDisplayAvailability(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return false;
        }
        return cpDefinitionInventory.getDisplayAvailability();
    }

    public boolean isDisplayStockQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return false;
        }
        return cpDefinitionInventory.getDisplayStockQuantity();
    }

    public int updateStockQuantity(CommerceWarehouseItem commerceWarehouseItem, int quantity) {
        quantity = commerceWarehouseItem.getQuantity() - quantity;
        commerceWarehouseItem.setQuantity(quantity);
        this._commerceWarehouseItemLocalService.updateCommerceWarehouseItem(commerceWarehouseItem);
        return quantity;
    }
}

