/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.NoSuchAvailabilityEstimateException;
import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.service.base.CPDAvailabilityEstimateLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;

public class CPDAvailabilityEstimateLocalServiceImpl
extends CPDAvailabilityEstimateLocalServiceBaseImpl {
    @Override
    @SystemEvent(type=1)
    public CPDAvailabilityEstimate deleteCPDAvailabilityEstimate(CPDAvailabilityEstimate cpdAvailabilityEstimate) {
        return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.remove((BaseModel)cpdAvailabilityEstimate);
    }

    @Override
    public CPDAvailabilityEstimate deleteCPDAvailabilityEstimate(long cpdAvailabilityEstimateId) throws PortalException {
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.findByPrimaryKey(cpdAvailabilityEstimateId);
        return this.cpdAvailabilityEstimateLocalService.deleteCPDAvailabilityEstimate(cpdAvailabilityEstimate);
    }

    public void deleteCPDAvailabilityEstimateByCPDefinitionId(long cpDefinitionId) {
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.fetchByCPDefinitionId(cpDefinitionId);
        if (cpdAvailabilityEstimate != null) {
            this.cpdAvailabilityEstimateLocalService.deleteCPDAvailabilityEstimate(cpdAvailabilityEstimate);
        }
    }

    public void deleteCPDAvailabilityEstimates(long commerceAvailabilityEstimateId) throws PortalException {
        this.cpdAvailabilityEstimatePersistence.removeByCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
    }

    public CPDAvailabilityEstimate fetchCPDAvailabilityEstimateByCPDefinitionId(long cpDefinitionId) {
        return this.cpdAvailabilityEstimatePersistence.fetchByCPDefinitionId(cpDefinitionId);
    }

    public CPDAvailabilityEstimate updateCPDAvailabilityEstimate(long cpdAvailabilityEstimateId, long cpDefinitionId, long commerceAvailabilityEstimateId, ServiceContext serviceContext) throws PortalException {
        this.validate(commerceAvailabilityEstimateId);
        if (cpdAvailabilityEstimateId > 0L) {
            CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.findByPrimaryKey(cpdAvailabilityEstimateId);
            cpdAvailabilityEstimate.setCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
            return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.update((BaseModel)cpdAvailabilityEstimate);
        }
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.fetchCPDAvailabilityEstimateByCPDefinitionId(cpDefinitionId);
        if (cpdAvailabilityEstimate != null) {
            cpdAvailabilityEstimate.setCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
            return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.update((BaseModel)cpdAvailabilityEstimate);
        }
        return this.addCPDAvailabilityEstimate(cpDefinitionId, commerceAvailabilityEstimateId, serviceContext);
    }

    protected CPDAvailabilityEstimate addCPDAvailabilityEstimate(long cpDefinitionId, long commerceAvailabilityEstimateId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        long cpdAvailabilityEstimateId = this.counterLocalService.increment();
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.create(cpdAvailabilityEstimateId);
        cpdAvailabilityEstimate.setUuid(serviceContext.getUuid());
        cpdAvailabilityEstimate.setGroupId(groupId);
        cpdAvailabilityEstimate.setCompanyId(user.getCompanyId());
        cpdAvailabilityEstimate.setUserId(user.getUserId());
        cpdAvailabilityEstimate.setUserName(user.getFullName());
        cpdAvailabilityEstimate.setCPDefinitionId(cpDefinitionId);
        cpdAvailabilityEstimate.setCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
        this.cpdAvailabilityEstimatePersistence.update((BaseModel)cpdAvailabilityEstimate);
        return cpdAvailabilityEstimate;
    }

    protected void validate(long commerceAvailabilityEstimateId) throws PortalException {
        CommerceAvailabilityEstimate commerceAvailabilityEstimate;
        if (commerceAvailabilityEstimateId > 0L && (commerceAvailabilityEstimate = this.commerceAvailabilityEstimateLocalService.fetchCommerceAvailabilityEstimate(commerceAvailabilityEstimateId)) == null) {
            throw new NoSuchAvailabilityEstimateException();
        }
    }
}

