/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.product.content.contributor;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.util.CPContentContributor;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.product.content.contributor.name=availabilityEstimate"}, service={CPContentContributor.class})
public class AvailabilityEstimateCPContentContributor
implements CPContentContributor {
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private JSONFactory _jsonFactory;

    public String getName() {
        return "availabilityEstimate";
    }

    public JSONObject getValue(CPInstance cpInstance, HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (cpInstance == null) {
            return jsonObject;
        }
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        boolean available = false;
        if (cpDefinitionInventoryEngine.getStockQuantity(cpInstance) > cpDefinitionInventoryEngine.getMinStockQuantity(cpInstance)) {
            available = true;
        }
        if (!available && cpDefinitionInventoryEngine.isBackOrderAllowed(cpInstance)) {
            jsonObject.put("availabilityEstimate", this.getAvailabilityEstimateLabel(themeDisplay.getLocale(), cpDefinitionInventoryEngine.getAvailabilityEstimate(cpInstance, themeDisplay.getLocale())));
        }
        return jsonObject;
    }

    protected String getAvailabilityEstimateLabel(Locale locale, String availabilityEstimate) {
        if (Validator.isNull((String)availabilityEstimate)) {
            return "";
        }
        return LanguageUtil.format((Locale)locale, (String)"product-will-be-available-in-x", (Object)availabilityEstimate);
    }
}

