/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.internal.price.CommerceProductPriceImpl;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryLocalService;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class CommerceProductPriceCalculationImpl
implements CommerceProductPriceCalculation {
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceDiscountCalculation _commerceDiscountCalculation;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CommerceTierPriceEntryLocalService _commerceTierPriceEntryLocalService;
    @Reference
    private CPInstanceService _cpInstanceService;

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        CommerceMoney unitPrice = this.getUnitPrice(cpInstanceId, quantity, commerceContext.getCommercePriceList(), commerceContext.getCommerceCurrency());
        CommerceMoney promoPrice = this.getPromoPrice(cpInstanceId, quantity, commerceContext.getCommercePriceList(), commerceContext.getCommerceCurrency());
        CommerceProductPriceImpl commerceProductPrice = new CommerceProductPriceImpl();
        commerceProductPrice.setQuantity(quantity);
        commerceProductPrice.setUnitPrice(unitPrice);
        commerceProductPrice.setUnitPromoPrice(promoPrice);
        CommerceDiscountValue commerceDiscountValue = this._commerceDiscountCalculation.getProductCommerceDiscountValue(cpInstanceId, quantity, unitPrice.getPrice(), commerceContext);
        BigDecimal finalPrice = unitPrice.getPrice();
        BigDecimal promo = promoPrice.getPrice();
        if (promo.compareTo(BigDecimal.ZERO) > 0 && promo.compareTo(unitPrice.getPrice()) <= 0) {
            finalPrice = promoPrice.getPrice();
        }
        finalPrice = finalPrice.multiply(BigDecimal.valueOf(quantity));
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmount = commerceDiscountValue.getDiscountAmount();
            finalPrice = finalPrice.subtract(discountAmount.getPrice());
        }
        commerceProductPrice.setCommerceDiscountValue(commerceDiscountValue);
        commerceProductPrice.setFinalPrice(this._commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), finalPrice));
        return commerceProductPrice;
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, int quantity, CommerceContext commerceContext) throws PortalException {
        CommerceProductPrice commerceProductPrice = this.getCommerceProductPrice(cpInstanceId, quantity, commerceContext);
        return commerceProductPrice.getFinalPrice();
    }

    public CommerceMoney getPromoPrice(long cpInstanceId, int quantity, Optional<CommercePriceList> commercePriceList, CommerceCurrency commerceCurrency) throws PortalException {
        BigDecimal priceListPrice;
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceId);
        BigDecimal price = cpInstance.getPromoPrice();
        if (commercePriceList.isPresent() && (priceListPrice = this._getPriceListPrice(cpInstanceId, quantity, commercePriceList.get(), true)) != null) {
            price = priceListPrice;
        }
        if (commerceCurrency != null && !commerceCurrency.isPrimary()) {
            price = price.multiply(commerceCurrency.getRate());
        }
        return this._commerceMoneyFactory.create(commerceCurrency, price);
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = null;
        BigDecimal maxPrice = BigDecimal.ZERO;
        List cpInstances = this._cpInstanceService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommercePriceList(), commerceContext.getCommerceCurrency());
            if (maxPrice.compareTo(cpInstanceCommerceMoney.getPrice()) >= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            maxPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, int quantity, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = null;
        BigDecimal minPrice = BigDecimal.ZERO;
        List cpInstances = this._cpInstanceService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommercePriceList(), commerceContext.getCommerceCurrency());
            if (commerceMoney != null && minPrice.compareTo(cpInstanceCommerceMoney.getPrice()) <= 0) continue;
            commerceMoney = cpInstanceCommerceMoney;
            minPrice = commerceMoney.getPrice();
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitPrice(long cpInstanceId, int quantity, Optional<CommercePriceList> commercePriceList, CommerceCurrency commerceCurrency) throws PortalException {
        BigDecimal priceListPrice;
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceId);
        BigDecimal price = cpInstance.getPrice();
        if (commercePriceList.isPresent() && (priceListPrice = this._getPriceListPrice(cpInstanceId, quantity, commercePriceList.get(), false)) != null) {
            price = priceListPrice;
        }
        if (commerceCurrency != null && !commerceCurrency.isPrimary()) {
            price = price.multiply(commerceCurrency.getRate());
        }
        return this._commerceMoneyFactory.create(commerceCurrency, price);
    }

    private BigDecimal _getPriceListPrice(long cpInstanceId, int quantity, CommercePriceList commercePriceList, boolean promo) throws PortalException {
        BigDecimal price = null;
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(cpInstanceId, commercePriceList.getCommercePriceListId());
        if (commercePriceEntry != null) {
            CommerceCurrency priceListCurrency;
            CommerceTierPriceEntry commerceTierPriceEntry;
            price = promo ? commercePriceEntry.getPromoPrice() : commercePriceEntry.getPrice();
            if (commercePriceEntry.getHasTierPrice() && (commerceTierPriceEntry = this._commerceTierPriceEntryLocalService.findClosestCommerceTierPriceEntry(commercePriceEntry.getCommercePriceEntryId(), quantity)) != null) {
                price = promo ? commerceTierPriceEntry.getPromoPrice() : commerceTierPriceEntry.getPrice();
            }
            if (!(priceListCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commercePriceList.getCommerceCurrencyId())).isPrimary()) {
                price = price.divide(priceListCurrency.getRate());
            }
        }
        return price;
    }
}

