/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.context;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountCouponCodeHelper;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.organization.util.CommerceOrganizationHelper;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.model.CPRule;
import com.liferay.commerce.product.service.CPRuleLocalService;
import com.liferay.commerce.user.segment.util.CommerceUserSegmentHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class CommerceContextImpl
implements CommerceContext {
    private CommerceCurrency _commerceCurrency;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private final CommerceDiscountCouponCodeHelper _commerceDiscountCouponCodeHelper;
    private CommerceOrder _commerceOrder;
    private final CommerceOrderHttpHelper _commerceOrderHttpHelper;
    private final CommerceOrganizationHelper _commerceOrganizationHelper;
    private Optional<CommercePriceList> _commercePriceList;
    private final CommercePriceListLocalService _commercePriceListLocalService;
    private long[] _commerceUserSegmentEntryIds;
    private final CommerceUserSegmentHelper _commerceUserSegmentHelper;
    private final CPRuleLocalService _cpRuleLocalService;
    private List<CPRule> _cpRules;
    private final HttpServletRequest _httpServletRequest;
    private Organization _organization;
    private final Portal _portal;

    public CommerceContextImpl(HttpServletRequest httpServletRequest, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceDiscountCouponCodeHelper commerceDiscountCouponCodeHelper, CommerceOrderHttpHelper commerceOrderHttpHelper, CommerceOrganizationHelper commerceOrganizationHelper, CommercePriceListLocalService commercePriceListLocalService, CommerceUserSegmentHelper commerceUserSegmentHelper, CPRuleLocalService cpRuleLocalService, Portal portal) {
        this._httpServletRequest = httpServletRequest;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceDiscountCouponCodeHelper = commerceDiscountCouponCodeHelper;
        this._commerceOrderHttpHelper = commerceOrderHttpHelper;
        this._commerceOrganizationHelper = commerceOrganizationHelper;
        this._commercePriceListLocalService = commercePriceListLocalService;
        this._commerceUserSegmentHelper = commerceUserSegmentHelper;
        this._cpRuleLocalService = cpRuleLocalService;
        this._portal = portal;
    }

    public CommerceCurrency getCommerceCurrency() throws PortalException {
        if (this._commerceCurrency != null) {
            return this._commerceCurrency;
        }
        long groupId = this._portal.getScopeGroupId(this._httpServletRequest);
        this._commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(groupId);
        return this._commerceCurrency;
    }

    public CommerceOrder getCommerceOrder() throws PortalException {
        if (this._commerceOrder != null) {
            return this._commerceOrder;
        }
        this._commerceOrder = this._commerceOrderHttpHelper.getCurrentCommerceOrder(this._httpServletRequest);
        return this._commerceOrder;
    }

    public Optional<CommercePriceList> getCommercePriceList() throws PortalException {
        if (this._commercePriceList != null) {
            return this._commercePriceList;
        }
        long groupId = this._portal.getScopeGroupId(this._httpServletRequest);
        this._commercePriceList = this._commercePriceListLocalService.getCommercePriceList(groupId, this.getCommerceUserSegmentEntryIds());
        return this._commercePriceList;
    }

    public long[] getCommerceUserSegmentEntryIds() throws PortalException {
        if (this._commerceUserSegmentEntryIds != null) {
            return this._commerceUserSegmentEntryIds;
        }
        this._commerceUserSegmentEntryIds = this._commerceUserSegmentHelper.getCommerceUserSegmentIds(this._httpServletRequest);
        return this._commerceUserSegmentEntryIds;
    }

    public String getCouponCode() throws PortalException {
        return this._commerceDiscountCouponCodeHelper.getCommerceDiscountCouponCode(this._httpServletRequest);
    }

    public List<CPRule> getCPRules() throws PortalException {
        if (this._cpRules != null) {
            return this._cpRules;
        }
        long groupId = this._portal.getScopeGroupId(this._httpServletRequest);
        this._cpRules = this._cpRuleLocalService.getCPRules(groupId, this.getCommerceUserSegmentEntryIds());
        return null;
    }

    public Organization getOrganization() throws PortalException {
        if (this._organization != null) {
            return this._organization;
        }
        this._organization = this._commerceOrganizationHelper.getCurrentOrganization(this._httpServletRequest);
        return this._organization;
    }

    public long getUserId() {
        return this._portal.getUserId(this._httpServletRequest);
    }
}

