/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.permission;

import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.permission.CommercePricingClassPermission;
import com.liferay.commerce.pricing.service.CommercePricingClassLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommercePricingClassPermission.class})
public class CommercePricingClassPermissionImpl
implements CommercePricingClassPermission {
    @Reference
    private CommercePricingClassLocalService _commercePricingClassLocalService;

    public void check(PermissionChecker permissionChecker, CommercePricingClass commercePricingClass, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commercePricingClass, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommercePricingClass.class.getName(), commercePricingClass.getCommercePricingClassId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commercePricingClassId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commercePricingClassId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommercePricingClass.class.getName(), commercePricingClassId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommercePricingClass commercePricingClass, String actionId) throws PortalException {
        return this.contains(permissionChecker, commercePricingClass.getCommercePricingClassId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commercePricingClassId, String actionId) throws PortalException {
        CommercePricingClass commercePricingClass = this._commercePricingClassLocalService.getCommercePricingClass(commercePricingClassId);
        if (commercePricingClass == null) {
            return false;
        }
        return this._contains(permissionChecker, commercePricingClass, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commercePricingClassIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commercePricingClassIds)) {
            return false;
        }
        for (long commercePricingClassId : commercePricingClassIds) {
            if (this.contains(permissionChecker, commercePricingClassId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommercePricingClass commercePricingClass, String actionId) {
        if (permissionChecker.isCompanyAdmin(commercePricingClass.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(commercePricingClass.getCompanyId(), CommercePricingClass.class.getName(), commercePricingClass.getCommercePricingClassId(), commercePricingClass.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(null, CommercePricingClass.class.getName(), commercePricingClass.getCommercePricingClassId(), actionId);
    }
}

