/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.type;

import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.type.CommercePriceModifierType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.price.modifier.type.key=fixed-amount", "commerce.price.modifier.type.order:Integer=20"}, service={CommercePriceModifierType.class})
public class FixedAmountCommercePriceModifierTypeImpl
implements CommercePriceModifierType {
    @Reference
    private Language _language;

    public BigDecimal evaluate(BigDecimal originalPrice, CommercePriceModifier commercePriceModifier) throws PortalException {
        BigDecimal amount = commercePriceModifier.getModifierAmount();
        BigDecimal modifiedPrice = originalPrice.add(amount);
        if (modifiedPrice.compareTo(BigDecimal.ZERO) < 0) {
            return amount;
        }
        return modifiedPrice;
    }

    public String getKey() {
        return "fixed-amount";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, "fixed-amount");
    }
}

