/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.pricing.exception.CommercePriceModifierAmountException;
import com.liferay.commerce.pricing.exception.CommercePriceModifierDisplayDateException;
import com.liferay.commerce.pricing.exception.CommercePriceModifierExpirationDateException;
import com.liferay.commerce.pricing.exception.CommercePriceModifierTargetException;
import com.liferay.commerce.pricing.exception.CommercePriceModifierTitleException;
import com.liferay.commerce.pricing.exception.CommercePriceModifierTypeException;
import com.liferay.commerce.pricing.exception.DuplicateCommercePriceModifierException;
import com.liferay.commerce.pricing.exception.NoSuchPriceModifierException;
import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.service.CommercePriceModifierRelLocalService;
import com.liferay.commerce.pricing.service.CommercePricingClassLocalService;
import com.liferay.commerce.pricing.service.base.CommercePriceModifierLocalServiceBaseImpl;
import com.liferay.commerce.pricing.type.CommercePriceModifierType;
import com.liferay.commerce.pricing.type.CommercePriceModifierTypeRegistry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.pricing.model.CommercePriceModifier"}, service={AopService.class})
public class CommercePriceModifierLocalServiceImpl
extends CommercePriceModifierLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommercePriceModifierLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CommercePriceModifierRelLocalService _commercePriceModifierRelLocalService;
    @Reference
    private CommercePriceModifierTypeRegistry _commercePriceModifierTypeRegistry;
    @Reference
    private CommercePricingClassLocalService _commercePricingClassLocalService;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public CommercePriceModifier addCommercePriceModifier(long groupId, String title, long commercePriceListId, String modifierType, BigDecimal modifierAmount, double priority, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceModifier(groupId, title, "catalog", commercePriceListId, modifierType, modifierAmount, priority, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommercePriceModifier addCommercePriceModifier(long groupId, String title, String target, long commercePriceListId, String modifierType, BigDecimal modifierAmount, double priority, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePriceModifier(null, groupId, title, target, commercePriceListId, modifierType, modifierAmount, priority, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommercePriceModifier addCommercePriceModifier(String externalReferenceCode, long groupId, String title, String target, long commercePriceListId, String modifierType, BigDecimal modifierAmount, double priority, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this._validateExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        Date date = new Date();
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommercePriceModifierDisplayDateException.class);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommercePriceModifierExpirationDateException.class);
        }
        long commercePriceModifierId = this.counterLocalService.increment();
        this._validate(title, target, modifierType, modifierAmount);
        CommercePriceModifier commercePriceModifier = this.commercePriceModifierPersistence.create(commercePriceModifierId);
        commercePriceModifier.setExternalReferenceCode(externalReferenceCode);
        commercePriceModifier.setGroupId(groupId);
        commercePriceModifier.setCompanyId(user.getCompanyId());
        commercePriceModifier.setUserId(user.getUserId());
        commercePriceModifier.setUserName(user.getFullName());
        commercePriceModifier.setCommercePriceListId(commercePriceListId);
        commercePriceModifier.setTitle(title);
        commercePriceModifier.setTarget(target);
        commercePriceModifier.setModifierAmount(modifierAmount);
        commercePriceModifier.setModifierType(modifierType);
        commercePriceModifier.setPriority(priority);
        commercePriceModifier.setActive(active);
        commercePriceModifier.setDisplayDate(displayDate);
        commercePriceModifier.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commercePriceModifier.setStatus(2);
        } else {
            commercePriceModifier.setStatus(3);
        }
        commercePriceModifier.setStatusByUserId(user.getUserId());
        commercePriceModifier.setStatusDate(serviceContext.getModifiedDate(date));
        commercePriceModifier.setExpandoBridgeAttributes(serviceContext);
        commercePriceModifier = (CommercePriceModifier)this.commercePriceModifierPersistence.update((BaseModel)commercePriceModifier);
        return this._startWorkflowInstance(user.getUserId(), commercePriceModifier, serviceContext);
    }

    public CommercePriceModifier addOrUpdateCommercePriceModifier(String externalReferenceCode, long userId, long commercePriceModifierId, long groupId, String title, String target, long commercePriceListId, String modifierType, BigDecimal modifierAmount, double priority, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommercePriceModifier commercePriceModifier;
        block4: {
            if (commercePriceModifierId > 0L) {
                try {
                    return this.commercePriceModifierLocalService.updateCommercePriceModifier(commercePriceModifierId, groupId, title, target, commercePriceListId, modifierType, modifierAmount, priority, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchPriceModifierException noSuchPriceModifierException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Unable to find price modifier with ID: " + commercePriceModifierId), (Throwable)noSuchPriceModifierException);
                }
            }
        }
        if (!Validator.isBlank((String)externalReferenceCode) && (commercePriceModifier = this.commercePriceModifierPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.commercePriceModifierLocalService.updateCommercePriceModifier(commercePriceModifierId, groupId, title, target, commercePriceListId, modifierType, modifierAmount, priority, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        return this.commercePriceModifierLocalService.addCommercePriceModifier(externalReferenceCode, groupId, title, target, commercePriceListId, modifierType, modifierAmount, priority, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public void checkCommercePriceModifiers() throws PortalException {
        this._checkCommercePriceModifiersByDisplayDate();
        this._checkCommercePriceModifiersByExpirationDate();
    }

    @Override
    @SystemEvent(type=1)
    public CommercePriceModifier deleteCommercePriceModifier(CommercePriceModifier commercePriceModifier) throws PortalException {
        this._commercePriceModifierRelLocalService.deleteCommercePriceModifierRels(commercePriceModifier.getCommercePriceModifierId());
        this.commercePriceModifierPersistence.remove((BaseModel)commercePriceModifier);
        this._expandoRowLocalService.deleteRows(commercePriceModifier.getCommercePriceModifierId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commercePriceModifier.getCompanyId(), 0L, CommercePriceModifier.class.getName(), commercePriceModifier.getCommercePriceModifierId());
        return commercePriceModifier;
    }

    @Override
    public CommercePriceModifier deleteCommercePriceModifier(long commercePriceModifierId) throws PortalException {
        CommercePriceModifier commercePriceModifier = this.commercePriceModifierPersistence.findByPrimaryKey(commercePriceModifierId);
        return this.commercePriceModifierLocalService.deleteCommercePriceModifier(commercePriceModifier);
    }

    public void deleteCommercePriceModifiers(long companyId) throws PortalException {
        List commercePriceModifiers = this.commercePriceModifierPersistence.findByCompanyId(companyId);
        for (CommercePriceModifier commercePriceModifier : commercePriceModifiers) {
            this.commercePriceModifierLocalService.deleteCommercePriceModifier(commercePriceModifier);
        }
    }

    public void deleteCommercePriceModifiersByCommercePriceListId(long commercePriceListId) throws PortalException {
        List commercePriceModifiers = this.commercePriceModifierPersistence.findByCommercePriceListId(commercePriceListId);
        for (CommercePriceModifier commercePriceModifier : commercePriceModifiers) {
            this.commercePriceModifierLocalService.deleteCommercePriceModifier(commercePriceModifier);
        }
    }

    public CommercePriceModifier fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commercePriceModifierPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public List<CommercePriceModifier> getCommercePriceModifiers(long commercePriceListId) {
        return this.commercePriceModifierPersistence.findByCommercePriceListId(commercePriceListId);
    }

    public List<CommercePriceModifier> getCommercePriceModifiers(long commercePriceListId, int start, int end, OrderByComparator<CommercePriceModifier> orderByComparator) {
        return this.commercePriceModifierPersistence.findByCommercePriceListId(commercePriceListId, start, end, orderByComparator);
    }

    public List<CommercePriceModifier> getCommercePriceModifiers(long companyId, String target) {
        return this.commercePriceModifierPersistence.findByC_T(companyId, target);
    }

    public int getCommercePriceModifiersCount(long commercePriceListId) {
        return this.commercePriceModifierPersistence.countByCommercePriceListId(commercePriceListId);
    }

    public List<CommercePriceModifier> getQualifiedCommercePriceModifiers(long commercePriceListId, long cpDefinitionId) {
        return this.commercePriceModifierFinder.findByC_C_C_P(commercePriceListId, cpDefinitionId, this._getAssetCategoryIds(cpDefinitionId), this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId));
    }

    public CommercePriceModifier updateCommercePriceModifier(long commercePriceModifierId, long groupId, String title, String target, long commercePriceListId, String modifierType, BigDecimal modifierAmount, double priority, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        CommercePriceModifier commercePriceModifier = this.commercePriceModifierPersistence.findByPrimaryKey(commercePriceModifierId);
        this._validate(title, target, modifierType, modifierAmount);
        String currentTarget = commercePriceModifier.getTarget();
        if (!currentTarget.equals(target)) {
            this._commercePriceModifierRelLocalService.deleteCommercePriceModifierRels(commercePriceModifier.getCommercePriceModifierId());
        }
        Date date = new Date();
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommercePriceModifierDisplayDateException.class);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommercePriceModifierExpirationDateException.class);
        }
        commercePriceModifier.setGroupId(groupId);
        commercePriceModifier.setCommercePriceListId(commercePriceListId);
        commercePriceModifier.setTitle(title);
        commercePriceModifier.setTarget(target);
        commercePriceModifier.setModifierAmount(modifierAmount);
        commercePriceModifier.setModifierType(modifierType);
        commercePriceModifier.setPriority(priority);
        commercePriceModifier.setActive(active);
        commercePriceModifier.setDisplayDate(displayDate);
        commercePriceModifier.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commercePriceModifier.setStatus(2);
        } else {
            commercePriceModifier.setStatus(3);
        }
        commercePriceModifier.setStatusByUserId(user.getUserId());
        commercePriceModifier.setStatusDate(serviceContext.getModifiedDate(date));
        commercePriceModifier.setExpandoBridgeAttributes(serviceContext);
        commercePriceModifier = (CommercePriceModifier)this.commercePriceModifierPersistence.update((BaseModel)commercePriceModifier);
        return this._startWorkflowInstance(user.getUserId(), commercePriceModifier, serviceContext);
    }

    public CommercePriceModifier updateStatus(long userId, long commercePriceModifierId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Date date = new Date();
        CommercePriceModifier commercePriceModifier = this.commercePriceModifierPersistence.findByPrimaryKey(commercePriceModifierId);
        if (status == 0 && commercePriceModifier.getDisplayDate() != null && date.before(commercePriceModifier.getDisplayDate())) {
            commercePriceModifier.setActive(false);
            status = 7;
        }
        if (status == 0) {
            Date expirationDate = commercePriceModifier.getExpirationDate();
            if (expirationDate != null && expirationDate.before(date)) {
                commercePriceModifier.setExpirationDate(null);
            }
            if (commercePriceModifier.getStatus() == 7) {
                commercePriceModifier.setActive(true);
            }
        }
        if (status == 3) {
            commercePriceModifier.setActive(false);
            commercePriceModifier.setExpirationDate(date);
        }
        commercePriceModifier.setStatus(status);
        commercePriceModifier.setStatusByUserId(user.getUserId());
        commercePriceModifier.setStatusByUserName(user.getFullName());
        commercePriceModifier.setStatusDate(serviceContext.getModifiedDate(date));
        return (CommercePriceModifier)this.commercePriceModifierPersistence.update((BaseModel)commercePriceModifier);
    }

    private void _checkCommercePriceModifiersByDisplayDate() throws PortalException {
        List commercePriceModifiers = this.commercePriceModifierPersistence.findByLtD_S(new Date(), 7);
        for (CommercePriceModifier commercePriceModifier : commercePriceModifiers) {
            long userId = this._portal.getValidUserId(commercePriceModifier.getCompanyId(), commercePriceModifier.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            serviceContext.setScopeGroupId(commercePriceModifier.getGroupId());
            this.commercePriceModifierLocalService.updateStatus(userId, commercePriceModifier.getCommercePriceModifierId(), 0, serviceContext, new HashMap());
        }
    }

    private void _checkCommercePriceModifiersByExpirationDate() throws PortalException {
        List commercePriceModifiers = this.commercePriceModifierPersistence.findByLtE_S(new Date(), 0);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + commercePriceModifiers.size() + " commerce price modifiers"));
        }
        if (commercePriceModifiers != null && !commercePriceModifiers.isEmpty()) {
            for (CommercePriceModifier commercePriceModifier : commercePriceModifiers) {
                long userId = this._portal.getValidUserId(commercePriceModifier.getCompanyId(), commercePriceModifier.getUserId());
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCommand("update");
                serviceContext.setScopeGroupId(commercePriceModifier.getGroupId());
                this.commercePriceModifierLocalService.updateStatus(userId, commercePriceModifier.getCommercePriceModifierId(), 3, serviceContext, new HashMap());
            }
        }
    }

    private long[] _getAssetCategoryIds(long cpDefinitionId) {
        try {
            AssetEntry assetEntry = this._assetEntryLocalService.getEntry(CPDefinition.class.getName(), cpDefinitionId);
            HashSet<AssetCategory> assetCategories = new HashSet<AssetCategory>();
            for (AssetCategory assetCategory : assetEntry.getCategories()) {
                assetCategories.add(assetCategory);
                assetCategories.addAll(assetCategory.getAncestors());
            }
            Stream stream = assetCategories.stream();
            LongStream longStream = stream.mapToLong(AssetCategoryModel::getCategoryId);
            return longStream.toArray();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return new long[0];
        }
    }

    private CommercePriceModifier _startWorkflowInstance(long userId, CommercePriceModifier commercePriceModifier, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommercePriceModifier)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commercePriceModifier.getCompanyId(), (long)0L, (long)userId, (String)CommercePriceModifier.class.getName(), (long)commercePriceModifier.getCommercePriceModifierId(), (Object)commercePriceModifier, (ServiceContext)serviceContext, workflowContext);
    }

    private void _validate(String title, String target, String modifierType, BigDecimal modifierAmount) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new CommercePriceModifierTitleException();
        }
        if (!("catalog".equals(target) || "categories".equals(target) || "product-groups".equals(target) || "products".equals(target))) {
            throw new CommercePriceModifierTargetException();
        }
        CommercePriceModifierType commercePriceModifierType = this._commercePriceModifierTypeRegistry.getCommercePriceModifierType(modifierType);
        if (commercePriceModifierType == null) {
            throw new CommercePriceModifierTypeException();
        }
        if (modifierAmount == null) {
            throw new CommercePriceModifierAmountException();
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommercePriceModifier commercePriceModifier = this.commercePriceModifierPersistence.fetchByC_ERC(companyId, externalReferenceCode);
        if (commercePriceModifier != null) {
            throw new DuplicateCommercePriceModifierException("There is another commerce price modifier with external reference code " + externalReferenceCode);
        }
    }
}

