/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.service.impl;

import com.liferay.commerce.pricing.exception.DuplicateCommercePricingClassCPDefinitionRelException;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRelModel;
import com.liferay.commerce.pricing.service.base.CommercePricingClassCPDefinitionRelLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommercePricingClassCPDefinitionRelLocalServiceImpl
extends CommercePricingClassCPDefinitionRelLocalServiceBaseImpl {
    public CommercePricingClassCPDefinitionRel addCommercePricingClassCPDefinitionRel(long commercePricingClassId, long cpDefinitionId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        this.validate(commercePricingClassId, cpDefinitionId);
        long commercePricingClassCPDefinitionRelId = this.counterLocalService.increment();
        CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel = this.commercePricingClassCPDefinitionRelPersistence.create(commercePricingClassCPDefinitionRelId);
        commercePricingClassCPDefinitionRel.setCompanyId(user.getCompanyId());
        commercePricingClassCPDefinitionRel.setUserId(user.getUserId());
        commercePricingClassCPDefinitionRel.setUserName(user.getFullName());
        commercePricingClassCPDefinitionRel.setCommercePricingClassId(commercePricingClassId);
        commercePricingClassCPDefinitionRel.setCPDefinitionId(cpDefinitionId);
        return (CommercePricingClassCPDefinitionRel)this.commercePricingClassCPDefinitionRelPersistence.update((BaseModel)commercePricingClassCPDefinitionRel);
    }

    @Override
    @SystemEvent(type=1)
    public CommercePricingClassCPDefinitionRel deleteCommercePricingClassCPDefinitionRel(CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel) throws PortalException {
        return (CommercePricingClassCPDefinitionRel)this.commercePricingClassCPDefinitionRelPersistence.remove((BaseModel)commercePricingClassCPDefinitionRel);
    }

    @Override
    public CommercePricingClassCPDefinitionRel deleteCommercePricingClassCPDefinitionRel(long commercePricingClassCPDefinitionRelId) throws PortalException {
        CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel = this.commercePricingClassCPDefinitionRelPersistence.findByPrimaryKey(commercePricingClassCPDefinitionRelId);
        return this.commercePricingClassCPDefinitionRelLocalService.deleteCommercePricingClassCPDefinitionRel(commercePricingClassCPDefinitionRel);
    }

    public void deleteCommercePricingClassCPDefinitionRels(long commercePricingClassId) throws PortalException {
        List commercePricingClassCPDefinitionRels = this.commercePricingClassCPDefinitionRelPersistence.findByCommercePricingClassId(commercePricingClassId);
        for (CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel : commercePricingClassCPDefinitionRels) {
            this.commercePricingClassCPDefinitionRelLocalService.deleteCommercePricingClassCPDefinitionRel(commercePricingClassCPDefinitionRel);
        }
    }

    public CommercePricingClassCPDefinitionRel fetchCommercePricingClassCPDefinitionRel(long commercePricingClassId, long cpDefinitionId) {
        return this.commercePricingClassCPDefinitionRelPersistence.fetchByC_C(commercePricingClassId, cpDefinitionId);
    }

    public List<CommercePricingClassCPDefinitionRel> getCommercePricingClassByCPDefinitionId(long cpDefinitionId) {
        return this.commercePricingClassCPDefinitionRelPersistence.findByCPDefinitionId(cpDefinitionId);
    }

    public List<CommercePricingClassCPDefinitionRel> getCommercePricingClassCPDefinitionRels(long commercePricingClassId) {
        return this.commercePricingClassCPDefinitionRelPersistence.findByCommercePricingClassId(commercePricingClassId);
    }

    public List<CommercePricingClassCPDefinitionRel> getCommercePricingClassCPDefinitionRels(long commercePricingClassId, int start, int end, OrderByComparator<CommercePricingClassCPDefinitionRel> orderByComparator) {
        return this.commercePricingClassCPDefinitionRelPersistence.findByCommercePricingClassId(commercePricingClassId, start, end, orderByComparator);
    }

    public int getCommercePricingClassCPDefinitionRelsCount(long commercePricingClassId) {
        return this.commercePricingClassCPDefinitionRelPersistence.countByCommercePricingClassId(commercePricingClassId);
    }

    public int getCommercePricingClassCPDefinitionRelsCount(long commercePricingClassId, String name, String languageId) {
        return this.commercePricingClassCPDefinitionRelFinder.countByCommercePricingClassId(commercePricingClassId, name, languageId);
    }

    public long[] getCPDefinitionIds(long commercePricingClassId) {
        return ListUtil.toLongArray((List)this.commercePricingClassCPDefinitionRelPersistence.findByCommercePricingClassId(commercePricingClassId), CommercePricingClassCPDefinitionRelModel::getCPDefinitionId);
    }

    public List<CommercePricingClassCPDefinitionRel> searchByCommercePricingClassId(long commercePricingClassId, String name, String languageId, int start, int end) {
        return this.commercePricingClassCPDefinitionRelFinder.findByCommercePricingClassId(commercePricingClassId, name, languageId, start, end);
    }

    protected void validate(long commercePricingClassId, long cpDefinitionId) throws PortalException {
        CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel = this.commercePricingClassCPDefinitionRelPersistence.fetchByC_C(commercePricingClassId, cpDefinitionId);
        if (commercePricingClassCPDefinitionRel != null) {
            throw new DuplicateCommercePricingClassCPDefinitionRelException();
        }
    }
}

