/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.upgrade.v2_0_0;

import com.liferay.commerce.pricing.internal.upgrade.v1_1_0.util.CommercePricingClassTable;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;

public class CommercePricingClassUpgradeProcess
extends UpgradeProcess {
    private static final String[] _OWNER_PERMISSIONS = new String[]{"DELETE", "PERMISSIONS", "UPDATE", "VIEW"};
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourceLocalService _resourceLocalService;

    public CommercePricingClassUpgradeProcess(ResourceActionLocalService resourceActionLocalService, ResourceLocalService resourceLocalService) {
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourceLocalService = resourceLocalService;
    }

    public void doUpgrade() throws Exception {
        this._resourceActionLocalService.checkResourceActions(CommercePricingClass.class.getName(), Arrays.asList(_OWNER_PERMISSIONS));
        ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])new String[0], (String[])new String[0]);
        modelPermissions.addRolePermissions("Owner", _OWNER_PERMISSIONS);
        String selectCommercePricingClassSQL = "select companyId, groupId, userId, commercePricingClassId from CommercePricingClass";
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(selectCommercePricingClassSQL);){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                long groupId = resultSet.getLong("groupId");
                long userId = resultSet.getLong("userId");
                long commercePricingClassId = resultSet.getLong("commercePricingClassId");
                this._resourceLocalService.addModelResources(companyId, groupId, userId, CommercePricingClass.class.getName(), commercePricingClassId, modelPermissions);
            }
        }
        if (this.hasColumn("CommercePricingClass", "groupId")) {
            this.alter(CommercePricingClassTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "groupId")});
        }
    }
}

