/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.pricing.model.impl;

import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.model.CommercePriceModifierModel;
import com.liferay.commerce.pricing.model.CommercePriceModifierSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommercePriceModifier service. Represents a row in the &quot;CommercePriceModifier&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommercePriceModifierModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommercePriceModifierImpl}.
 * </p>
 *
 * @author Riccardo Alberti
 * @see CommercePriceModifierImpl
 * @generated
 */
@JSON(strict = true)
public class CommercePriceModifierModelImpl
	extends BaseModelImpl<CommercePriceModifier>
	implements CommercePriceModifierModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce price modifier model instance should use the <code>CommercePriceModifier</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommercePriceModifier";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"commercePriceModifierId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP},
		{"commercePriceListId", Types.BIGINT}, {"title", Types.VARCHAR},
		{"target", Types.VARCHAR}, {"modifierAmount", Types.DECIMAL},
		{"modifierType", Types.VARCHAR}, {"priority", Types.DOUBLE},
		{"active_", Types.BOOLEAN}, {"displayDate", Types.TIMESTAMP},
		{"expirationDate", Types.TIMESTAMP},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commercePriceModifierId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commercePriceListId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("target", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("modifierAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("modifierType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommercePriceModifier (uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commercePriceModifierId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commercePriceListId LONG,title VARCHAR(75) null,target VARCHAR(75) null,modifierAmount DECIMAL(30, 16) null,modifierType VARCHAR(75) null,priority DOUBLE,active_ BOOLEAN,displayDate DATE null,expirationDate DATE null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP =
		"drop table CommercePriceModifier";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commercePriceModifier.displayDate DESC, commercePriceModifier.createDate DESC, commercePriceModifier.priority DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommercePriceModifier.displayDate DESC, CommercePriceModifier.createDate DESC, CommercePriceModifier.priority DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long COMMERCEPRICELISTID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long DISPLAYDATE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long EXPIRATIONDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long TARGET_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)
	 */
	@Deprecated
	public static final long PRIORITY_COLUMN_BITMASK = 1024L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static CommercePriceModifier toModel(
		CommercePriceModifierSoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		CommercePriceModifier model = new CommercePriceModifierImpl();

		model.setUuid(soapModel.getUuid());
		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setCommercePriceModifierId(
			soapModel.getCommercePriceModifierId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommercePriceListId(soapModel.getCommercePriceListId());
		model.setTitle(soapModel.getTitle());
		model.setTarget(soapModel.getTarget());
		model.setModifierAmount(soapModel.getModifierAmount());
		model.setModifierType(soapModel.getModifierType());
		model.setPriority(soapModel.getPriority());
		model.setActive(soapModel.isActive());
		model.setDisplayDate(soapModel.getDisplayDate());
		model.setExpirationDate(soapModel.getExpirationDate());
		model.setLastPublishDate(soapModel.getLastPublishDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<CommercePriceModifier> toModels(
		CommercePriceModifierSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommercePriceModifier> models =
			new ArrayList<CommercePriceModifier>(soapModels.length);

		for (CommercePriceModifierSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.pricing.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.pricing.model.CommercePriceModifier"));

	public CommercePriceModifierModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commercePriceModifierId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommercePriceModifierId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commercePriceModifierId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommercePriceModifier.class;
	}

	@Override
	public String getModelClassName() {
		return CommercePriceModifier.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommercePriceModifier, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommercePriceModifier, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePriceModifier, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommercePriceModifier)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommercePriceModifier, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommercePriceModifier, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommercePriceModifier)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommercePriceModifier, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommercePriceModifier, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommercePriceModifier>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommercePriceModifier.class.getClassLoader(),
			CommercePriceModifier.class, ModelWrapper.class);

		try {
			Constructor<CommercePriceModifier> constructor =
				(Constructor<CommercePriceModifier>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<CommercePriceModifier, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommercePriceModifier, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommercePriceModifier, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommercePriceModifier, Object>>();
		Map<String, BiConsumer<CommercePriceModifier, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommercePriceModifier, ?>>();

		attributeGetterFunctions.put("uuid", CommercePriceModifier::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<CommercePriceModifier, String>)
				CommercePriceModifier::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode",
			CommercePriceModifier::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommercePriceModifier, String>)
				CommercePriceModifier::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"commercePriceModifierId",
			CommercePriceModifier::getCommercePriceModifierId);
		attributeSetterBiConsumers.put(
			"commercePriceModifierId",
			(BiConsumer<CommercePriceModifier, Long>)
				CommercePriceModifier::setCommercePriceModifierId);
		attributeGetterFunctions.put(
			"groupId", CommercePriceModifier::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<CommercePriceModifier, Long>)
				CommercePriceModifier::setGroupId);
		attributeGetterFunctions.put(
			"companyId", CommercePriceModifier::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommercePriceModifier, Long>)
				CommercePriceModifier::setCompanyId);
		attributeGetterFunctions.put(
			"userId", CommercePriceModifier::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommercePriceModifier, Long>)
				CommercePriceModifier::setUserId);
		attributeGetterFunctions.put(
			"userName", CommercePriceModifier::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommercePriceModifier, String>)
				CommercePriceModifier::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommercePriceModifier::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommercePriceModifier, Date>)
				CommercePriceModifier::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommercePriceModifier::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommercePriceModifier, Date>)
				CommercePriceModifier::setModifiedDate);
		attributeGetterFunctions.put(
			"commercePriceListId",
			CommercePriceModifier::getCommercePriceListId);
		attributeSetterBiConsumers.put(
			"commercePriceListId",
			(BiConsumer<CommercePriceModifier, Long>)
				CommercePriceModifier::setCommercePriceListId);
		attributeGetterFunctions.put("title", CommercePriceModifier::getTitle);
		attributeSetterBiConsumers.put(
			"title",
			(BiConsumer<CommercePriceModifier, String>)
				CommercePriceModifier::setTitle);
		attributeGetterFunctions.put(
			"target", CommercePriceModifier::getTarget);
		attributeSetterBiConsumers.put(
			"target",
			(BiConsumer<CommercePriceModifier, String>)
				CommercePriceModifier::setTarget);
		attributeGetterFunctions.put(
			"modifierAmount", CommercePriceModifier::getModifierAmount);
		attributeSetterBiConsumers.put(
			"modifierAmount",
			(BiConsumer<CommercePriceModifier, BigDecimal>)
				CommercePriceModifier::setModifierAmount);
		attributeGetterFunctions.put(
			"modifierType", CommercePriceModifier::getModifierType);
		attributeSetterBiConsumers.put(
			"modifierType",
			(BiConsumer<CommercePriceModifier, String>)
				CommercePriceModifier::setModifierType);
		attributeGetterFunctions.put(
			"priority", CommercePriceModifier::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<CommercePriceModifier, Double>)
				CommercePriceModifier::setPriority);
		attributeGetterFunctions.put(
			"active", CommercePriceModifier::getActive);
		attributeSetterBiConsumers.put(
			"active",
			(BiConsumer<CommercePriceModifier, Boolean>)
				CommercePriceModifier::setActive);
		attributeGetterFunctions.put(
			"displayDate", CommercePriceModifier::getDisplayDate);
		attributeSetterBiConsumers.put(
			"displayDate",
			(BiConsumer<CommercePriceModifier, Date>)
				CommercePriceModifier::setDisplayDate);
		attributeGetterFunctions.put(
			"expirationDate", CommercePriceModifier::getExpirationDate);
		attributeSetterBiConsumers.put(
			"expirationDate",
			(BiConsumer<CommercePriceModifier, Date>)
				CommercePriceModifier::setExpirationDate);
		attributeGetterFunctions.put(
			"lastPublishDate", CommercePriceModifier::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<CommercePriceModifier, Date>)
				CommercePriceModifier::setLastPublishDate);
		attributeGetterFunctions.put(
			"status", CommercePriceModifier::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<CommercePriceModifier, Integer>)
				CommercePriceModifier::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", CommercePriceModifier::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<CommercePriceModifier, Long>)
				CommercePriceModifier::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", CommercePriceModifier::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<CommercePriceModifier, String>)
				CommercePriceModifier::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", CommercePriceModifier::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<CommercePriceModifier, Date>)
				CommercePriceModifier::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommercePriceModifierId() {
		return _commercePriceModifierId;
	}

	@Override
	public void setCommercePriceModifierId(long commercePriceModifierId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePriceModifierId = commercePriceModifierId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommercePriceListId() {
		return _commercePriceListId;
	}

	@Override
	public void setCommercePriceListId(long commercePriceListId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePriceListId = commercePriceListId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommercePriceListId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commercePriceListId"));
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	@JSON
	@Override
	public String getTarget() {
		if (_target == null) {
			return "";
		}
		else {
			return _target;
		}
	}

	@Override
	public void setTarget(String target) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_target = target;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalTarget() {
		return getColumnOriginalValue("target");
	}

	@JSON
	@Override
	public BigDecimal getModifierAmount() {
		return _modifierAmount;
	}

	@Override
	public void setModifierAmount(BigDecimal modifierAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifierAmount = modifierAmount;
	}

	@JSON
	@Override
	public String getModifierType() {
		if (_modifierType == null) {
			return "";
		}
		else {
			return _modifierType;
		}
	}

	@Override
	public void setModifierType(String modifierType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifierType = modifierType;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalDisplayDate() {
		return getColumnOriginalValue("displayDate");
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalExpirationDate() {
		return getColumnOriginalValue("expirationDate");
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommercePriceModifier.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (entry.getValue() != getColumnValue(entry.getKey())) {
				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommercePriceModifier.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommercePriceModifier toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommercePriceModifier>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommercePriceModifierImpl commercePriceModifierImpl =
			new CommercePriceModifierImpl();

		commercePriceModifierImpl.setUuid(getUuid());
		commercePriceModifierImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commercePriceModifierImpl.setCommercePriceModifierId(
			getCommercePriceModifierId());
		commercePriceModifierImpl.setGroupId(getGroupId());
		commercePriceModifierImpl.setCompanyId(getCompanyId());
		commercePriceModifierImpl.setUserId(getUserId());
		commercePriceModifierImpl.setUserName(getUserName());
		commercePriceModifierImpl.setCreateDate(getCreateDate());
		commercePriceModifierImpl.setModifiedDate(getModifiedDate());
		commercePriceModifierImpl.setCommercePriceListId(
			getCommercePriceListId());
		commercePriceModifierImpl.setTitle(getTitle());
		commercePriceModifierImpl.setTarget(getTarget());
		commercePriceModifierImpl.setModifierAmount(getModifierAmount());
		commercePriceModifierImpl.setModifierType(getModifierType());
		commercePriceModifierImpl.setPriority(getPriority());
		commercePriceModifierImpl.setActive(isActive());
		commercePriceModifierImpl.setDisplayDate(getDisplayDate());
		commercePriceModifierImpl.setExpirationDate(getExpirationDate());
		commercePriceModifierImpl.setLastPublishDate(getLastPublishDate());
		commercePriceModifierImpl.setStatus(getStatus());
		commercePriceModifierImpl.setStatusByUserId(getStatusByUserId());
		commercePriceModifierImpl.setStatusByUserName(getStatusByUserName());
		commercePriceModifierImpl.setStatusDate(getStatusDate());

		commercePriceModifierImpl.resetOriginalValues();

		return commercePriceModifierImpl;
	}

	@Override
	public int compareTo(CommercePriceModifier commercePriceModifier) {
		int value = 0;

		value = DateUtil.compareTo(
			getDisplayDate(), commercePriceModifier.getDisplayDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		value = DateUtil.compareTo(
			getCreateDate(), commercePriceModifier.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		if (getPriority() < commercePriceModifier.getPriority()) {
			value = -1;
		}
		else if (getPriority() > commercePriceModifier.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommercePriceModifier)) {
			return false;
		}

		CommercePriceModifier commercePriceModifier =
			(CommercePriceModifier)object;

		long primaryKey = commercePriceModifier.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommercePriceModifier> toCacheModel() {
		CommercePriceModifierCacheModel commercePriceModifierCacheModel =
			new CommercePriceModifierCacheModel();

		commercePriceModifierCacheModel.uuid = getUuid();

		String uuid = commercePriceModifierCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commercePriceModifierCacheModel.uuid = null;
		}

		commercePriceModifierCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commercePriceModifierCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commercePriceModifierCacheModel.externalReferenceCode = null;
		}

		commercePriceModifierCacheModel.commercePriceModifierId =
			getCommercePriceModifierId();

		commercePriceModifierCacheModel.groupId = getGroupId();

		commercePriceModifierCacheModel.companyId = getCompanyId();

		commercePriceModifierCacheModel.userId = getUserId();

		commercePriceModifierCacheModel.userName = getUserName();

		String userName = commercePriceModifierCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commercePriceModifierCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commercePriceModifierCacheModel.createDate = createDate.getTime();
		}
		else {
			commercePriceModifierCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commercePriceModifierCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commercePriceModifierCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commercePriceModifierCacheModel.commercePriceListId =
			getCommercePriceListId();

		commercePriceModifierCacheModel.title = getTitle();

		String title = commercePriceModifierCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			commercePriceModifierCacheModel.title = null;
		}

		commercePriceModifierCacheModel.target = getTarget();

		String target = commercePriceModifierCacheModel.target;

		if ((target != null) && (target.length() == 0)) {
			commercePriceModifierCacheModel.target = null;
		}

		commercePriceModifierCacheModel.modifierAmount = getModifierAmount();

		commercePriceModifierCacheModel.modifierType = getModifierType();

		String modifierType = commercePriceModifierCacheModel.modifierType;

		if ((modifierType != null) && (modifierType.length() == 0)) {
			commercePriceModifierCacheModel.modifierType = null;
		}

		commercePriceModifierCacheModel.priority = getPriority();

		commercePriceModifierCacheModel.active = isActive();

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			commercePriceModifierCacheModel.displayDate = displayDate.getTime();
		}
		else {
			commercePriceModifierCacheModel.displayDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			commercePriceModifierCacheModel.expirationDate =
				expirationDate.getTime();
		}
		else {
			commercePriceModifierCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			commercePriceModifierCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			commercePriceModifierCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		commercePriceModifierCacheModel.status = getStatus();

		commercePriceModifierCacheModel.statusByUserId = getStatusByUserId();

		commercePriceModifierCacheModel.statusByUserName =
			getStatusByUserName();

		String statusByUserName =
			commercePriceModifierCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commercePriceModifierCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commercePriceModifierCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commercePriceModifierCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commercePriceModifierCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommercePriceModifier, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			4 * attributeGetterFunctions.size() + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommercePriceModifier, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePriceModifier, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(
				attributeGetterFunction.apply((CommercePriceModifier)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommercePriceModifier, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			5 * attributeGetterFunctions.size() + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommercePriceModifier, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePriceModifier, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((CommercePriceModifier)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommercePriceModifier>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private String _uuid;
	private String _externalReferenceCode;
	private long _commercePriceModifierId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commercePriceListId;
	private String _title;
	private String _target;
	private BigDecimal _modifierAmount;
	private String _modifierType;
	private double _priority;
	private boolean _active;
	private Date _displayDate;
	private Date _expirationDate;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommercePriceModifier, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommercePriceModifier)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put(
			"commercePriceModifierId", _commercePriceModifierId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("commercePriceListId", _commercePriceListId);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("target", _target);
		_columnOriginalValues.put("modifierAmount", _modifierAmount);
		_columnOriginalValues.put("modifierType", _modifierType);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("active_", "active");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("uuid_", 1L);

		columnBitmasks.put("externalReferenceCode", 2L);

		columnBitmasks.put("commercePriceModifierId", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("commercePriceListId", 512L);

		columnBitmasks.put("title", 1024L);

		columnBitmasks.put("target", 2048L);

		columnBitmasks.put("modifierAmount", 4096L);

		columnBitmasks.put("modifierType", 8192L);

		columnBitmasks.put("priority", 16384L);

		columnBitmasks.put("active_", 32768L);

		columnBitmasks.put("displayDate", 65536L);

		columnBitmasks.put("expirationDate", 131072L);

		columnBitmasks.put("lastPublishDate", 262144L);

		columnBitmasks.put("status", 524288L);

		columnBitmasks.put("statusByUserId", 1048576L);

		columnBitmasks.put("statusByUserName", 2097152L);

		columnBitmasks.put("statusDate", 4194304L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommercePriceModifier _escapedModel;

}