/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.upgrade.base;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Objects;

public abstract class BaseCommercePricingUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommercePricingUpgradeProcess.class);

    protected void changeColumnType(Class<?> tableClass, String tableName, String columnName, String newColumnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Changing column %s to type %s for table %s", columnName, newColumnType, tableName));
        }
        if (this.hasColumn(tableName, columnName)) {
            this.alter(tableClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, columnName, newColumnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("No column %s exists on table %s", columnName, tableName));
        }
    }

    protected abstract void doUpgrade() throws Exception;

    protected void dropColumn(String tableName, String columnName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Dropping column %s from table %s", columnName, tableName));
        }
        if (this.hasColumn(tableName, columnName)) {
            this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", tableName, " drop column ", columnName}));
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s does not exist on table %s", columnName, tableName));
        }
    }

    protected void dropIndex(String tableName, String indexName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Dropping index %s from table %s", indexName, tableName));
        }
        if (this._tableHasIndex(tableName, indexName)) {
            this.runSQL(StringBundler.concat((String[])new String[]{"drop index ", indexName, " on ", tableName}));
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Index %s already does not exist on table %s", indexName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _tableHasIndex(String tableName, String indexName) throws Exception {
        boolean bl;
        ResultSet rs = null;
        try {
            DatabaseMetaData metadata = this.connection.getMetaData();
            rs = metadata.getIndexInfo(null, null, tableName, false, false);
            while (rs.next()) {
                String curIndexName = rs.getString("index_name");
                if (!Objects.equals(indexName, curIndexName)) break block4;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(rs);
            throw throwable;
        }
        {
            block4: {
                DataAccess.cleanUp((ResultSet)rs);
                return bl;
            }
            continue;
        }
        DataAccess.cleanUp((ResultSet)rs);
        return false;
    }
}

