/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.pricing.model.impl;

/**
 * The extended model implementation for the CommercePricingClass service. Represents a row in the &quot;CommercePricingClass&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * Helper methods and all application logic should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the <code>com.liferay.commerce.pricing.model.CommercePricingClass</code> interface.
 * </p>
 *
 * @author Riccardo Alberti
 */
public class CommercePricingClassImpl extends CommercePricingClassBaseImpl {

	/**
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this class directly. All methods that expect a commerce pricing class model instance should use the {@link com.liferay.commerce.pricing.model.CommercePricingClass} interface instead.
	 */
	public CommercePricingClassImpl() {
	}

}