/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.pricing.model.impl;

import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRelModel;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRelSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommercePricingClassCPDefinitionRel service. Represents a row in the &quot;CPricingClassCPDefinitionRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommercePricingClassCPDefinitionRelModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommercePricingClassCPDefinitionRelImpl}.
 * </p>
 *
 * @author Riccardo Alberti
 * @see CommercePricingClassCPDefinitionRelImpl
 * @generated
 */
@JSON(strict = true)
public class CommercePricingClassCPDefinitionRelModelImpl
	extends BaseModelImpl<CommercePricingClassCPDefinitionRel>
	implements CommercePricingClassCPDefinitionRelModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce pricing class cp definition rel model instance should use the <code>CommercePricingClassCPDefinitionRel</code> interface instead.
	 */
	public static final String TABLE_NAME = "CPricingClassCPDefinitionRel";

	public static final Object[][] TABLE_COLUMNS = {
		{"CPricingClassCPDefinitionRelId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP},
		{"commercePricingClassId", Types.BIGINT},
		{"CPDefinitionId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("CPricingClassCPDefinitionRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commercePricingClassId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CPDefinitionId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CPricingClassCPDefinitionRel (CPricingClassCPDefinitionRelId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commercePricingClassId LONG,CPDefinitionId LONG)";

	public static final String TABLE_SQL_DROP =
		"drop table CPricingClassCPDefinitionRel";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commercePricingClassCPDefinitionRel.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CPricingClassCPDefinitionRel.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.pricing.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.pricing.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.pricing.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel"),
		true);

	public static final long CPDEFINITIONID_COLUMN_BITMASK = 1L;

	public static final long COMMERCEPRICINGCLASSID_COLUMN_BITMASK = 2L;

	public static final long CREATEDATE_COLUMN_BITMASK = 4L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommercePricingClassCPDefinitionRel toModel(
		CommercePricingClassCPDefinitionRelSoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		CommercePricingClassCPDefinitionRel model =
			new CommercePricingClassCPDefinitionRelImpl();

		model.setCommercePricingClassCPDefinitionRelId(
			soapModel.getCommercePricingClassCPDefinitionRelId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommercePricingClassId(soapModel.getCommercePricingClassId());
		model.setCPDefinitionId(soapModel.getCPDefinitionId());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommercePricingClassCPDefinitionRel> toModels(
		CommercePricingClassCPDefinitionRelSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommercePricingClassCPDefinitionRel> models =
			new ArrayList<CommercePricingClassCPDefinitionRel>(
				soapModels.length);

		for (CommercePricingClassCPDefinitionRelSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.pricing.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel"));

	public CommercePricingClassCPDefinitionRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _CommercePricingClassCPDefinitionRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommercePricingClassCPDefinitionRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _CommercePricingClassCPDefinitionRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommercePricingClassCPDefinitionRel.class;
	}

	@Override
	public String getModelClassName() {
		return CommercePricingClassCPDefinitionRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommercePricingClassCPDefinitionRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry
				<String, Function<CommercePricingClassCPDefinitionRel, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePricingClassCPDefinitionRel, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommercePricingClassCPDefinitionRel)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommercePricingClassCPDefinitionRel, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommercePricingClassCPDefinitionRel, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommercePricingClassCPDefinitionRel)this,
					entry.getValue());
			}
		}
	}

	public Map<String, Function<CommercePricingClassCPDefinitionRel, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommercePricingClassCPDefinitionRel, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function
		<InvocationHandler, CommercePricingClassCPDefinitionRel>
			_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommercePricingClassCPDefinitionRel.class.getClassLoader(),
			CommercePricingClassCPDefinitionRel.class, ModelWrapper.class);

		try {
			Constructor<CommercePricingClassCPDefinitionRel> constructor =
				(Constructor<CommercePricingClassCPDefinitionRel>)
					proxyClass.getConstructor(InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map
		<String, Function<CommercePricingClassCPDefinitionRel, Object>>
			_attributeGetterFunctions;

	static {
		Map<String, Function<CommercePricingClassCPDefinitionRel, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String,
					 Function<CommercePricingClassCPDefinitionRel, Object>>();

		attributeGetterFunctions.put(
			"CommercePricingClassCPDefinitionRelId",
			new Function<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public Object apply(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel) {

					return commercePricingClassCPDefinitionRel.
						getCommercePricingClassCPDefinitionRelId();
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public Object apply(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel) {

					return commercePricingClassCPDefinitionRel.getCompanyId();
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public Object apply(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel) {

					return commercePricingClassCPDefinitionRel.getUserId();
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public Object apply(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel) {

					return commercePricingClassCPDefinitionRel.getUserName();
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public Object apply(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel) {

					return commercePricingClassCPDefinitionRel.getCreateDate();
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public Object apply(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel) {

					return commercePricingClassCPDefinitionRel.
						getModifiedDate();
				}

			});
		attributeGetterFunctions.put(
			"commercePricingClassId",
			new Function<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public Object apply(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel) {

					return commercePricingClassCPDefinitionRel.
						getCommercePricingClassId();
				}

			});
		attributeGetterFunctions.put(
			"CPDefinitionId",
			new Function<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public Object apply(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel) {

					return commercePricingClassCPDefinitionRel.
						getCPDefinitionId();
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map
		<String, BiConsumer<CommercePricingClassCPDefinitionRel, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<CommercePricingClassCPDefinitionRel, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String,
					 BiConsumer<CommercePricingClassCPDefinitionRel, ?>>();

		attributeSetterBiConsumers.put(
			"CommercePricingClassCPDefinitionRelId",
			new BiConsumer<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public void accept(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel,
					Object CommercePricingClassCPDefinitionRelIdObject) {

					commercePricingClassCPDefinitionRel.
						setCommercePricingClassCPDefinitionRelId(
							(Long)CommercePricingClassCPDefinitionRelIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public void accept(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel,
					Object companyIdObject) {

					commercePricingClassCPDefinitionRel.setCompanyId(
						(Long)companyIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public void accept(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel,
					Object userIdObject) {

					commercePricingClassCPDefinitionRel.setUserId(
						(Long)userIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public void accept(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel,
					Object userNameObject) {

					commercePricingClassCPDefinitionRel.setUserName(
						(String)userNameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public void accept(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel,
					Object createDateObject) {

					commercePricingClassCPDefinitionRel.setCreateDate(
						(Date)createDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public void accept(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel,
					Object modifiedDateObject) {

					commercePricingClassCPDefinitionRel.setModifiedDate(
						(Date)modifiedDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"commercePricingClassId",
			new BiConsumer<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public void accept(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel,
					Object commercePricingClassIdObject) {

					commercePricingClassCPDefinitionRel.
						setCommercePricingClassId(
							(Long)commercePricingClassIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"CPDefinitionId",
			new BiConsumer<CommercePricingClassCPDefinitionRel, Object>() {

				@Override
				public void accept(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel,
					Object CPDefinitionIdObject) {

					commercePricingClassCPDefinitionRel.setCPDefinitionId(
						(Long)CPDefinitionIdObject);
				}

			});

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getCommercePricingClassCPDefinitionRelId() {
		return _CommercePricingClassCPDefinitionRelId;
	}

	@Override
	public void setCommercePricingClassCPDefinitionRelId(
		long CommercePricingClassCPDefinitionRelId) {

		_CommercePricingClassCPDefinitionRelId =
			CommercePricingClassCPDefinitionRelId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommercePricingClassId() {
		return _commercePricingClassId;
	}

	@Override
	public void setCommercePricingClassId(long commercePricingClassId) {
		_columnBitmask |= COMMERCEPRICINGCLASSID_COLUMN_BITMASK;

		if (!_setOriginalCommercePricingClassId) {
			_setOriginalCommercePricingClassId = true;

			_originalCommercePricingClassId = _commercePricingClassId;
		}

		_commercePricingClassId = commercePricingClassId;
	}

	public long getOriginalCommercePricingClassId() {
		return _originalCommercePricingClassId;
	}

	@JSON
	@Override
	public long getCPDefinitionId() {
		return _CPDefinitionId;
	}

	@Override
	public void setCPDefinitionId(long CPDefinitionId) {
		_columnBitmask |= CPDEFINITIONID_COLUMN_BITMASK;

		if (!_setOriginalCPDefinitionId) {
			_setOriginalCPDefinitionId = true;

			_originalCPDefinitionId = _CPDefinitionId;
		}

		_CPDefinitionId = CPDefinitionId;
	}

	public long getOriginalCPDefinitionId() {
		return _originalCPDefinitionId;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommercePricingClassCPDefinitionRel.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommercePricingClassCPDefinitionRel toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommercePricingClassCPDefinitionRel>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommercePricingClassCPDefinitionRelImpl
			commercePricingClassCPDefinitionRelImpl =
				new CommercePricingClassCPDefinitionRelImpl();

		commercePricingClassCPDefinitionRelImpl.
			setCommercePricingClassCPDefinitionRelId(
				getCommercePricingClassCPDefinitionRelId());
		commercePricingClassCPDefinitionRelImpl.setCompanyId(getCompanyId());
		commercePricingClassCPDefinitionRelImpl.setUserId(getUserId());
		commercePricingClassCPDefinitionRelImpl.setUserName(getUserName());
		commercePricingClassCPDefinitionRelImpl.setCreateDate(getCreateDate());
		commercePricingClassCPDefinitionRelImpl.setModifiedDate(
			getModifiedDate());
		commercePricingClassCPDefinitionRelImpl.setCommercePricingClassId(
			getCommercePricingClassId());
		commercePricingClassCPDefinitionRelImpl.setCPDefinitionId(
			getCPDefinitionId());

		commercePricingClassCPDefinitionRelImpl.resetOriginalValues();

		return commercePricingClassCPDefinitionRelImpl;
	}

	@Override
	public int compareTo(
		CommercePricingClassCPDefinitionRel
			commercePricingClassCPDefinitionRel) {

		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(),
			commercePricingClassCPDefinitionRel.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommercePricingClassCPDefinitionRel)) {
			return false;
		}

		CommercePricingClassCPDefinitionRel
			commercePricingClassCPDefinitionRel =
				(CommercePricingClassCPDefinitionRel)object;

		long primaryKey = commercePricingClassCPDefinitionRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_setModifiedDate = false;
		_originalCommercePricingClassId = _commercePricingClassId;

		_setOriginalCommercePricingClassId = false;

		_originalCPDefinitionId = _CPDefinitionId;

		_setOriginalCPDefinitionId = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommercePricingClassCPDefinitionRel> toCacheModel() {
		CommercePricingClassCPDefinitionRelCacheModel
			commercePricingClassCPDefinitionRelCacheModel =
				new CommercePricingClassCPDefinitionRelCacheModel();

		commercePricingClassCPDefinitionRelCacheModel.
			CommercePricingClassCPDefinitionRelId =
				getCommercePricingClassCPDefinitionRelId();

		commercePricingClassCPDefinitionRelCacheModel.companyId =
			getCompanyId();

		commercePricingClassCPDefinitionRelCacheModel.userId = getUserId();

		commercePricingClassCPDefinitionRelCacheModel.userName = getUserName();

		String userName =
			commercePricingClassCPDefinitionRelCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commercePricingClassCPDefinitionRelCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commercePricingClassCPDefinitionRelCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commercePricingClassCPDefinitionRelCacheModel.createDate =
				Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commercePricingClassCPDefinitionRelCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commercePricingClassCPDefinitionRelCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		commercePricingClassCPDefinitionRelCacheModel.commercePricingClassId =
			getCommercePricingClassId();

		commercePricingClassCPDefinitionRelCacheModel.CPDefinitionId =
			getCPDefinitionId();

		return commercePricingClassCPDefinitionRelCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommercePricingClassCPDefinitionRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry
				<String, Function<CommercePricingClassCPDefinitionRel, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePricingClassCPDefinitionRel, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommercePricingClassCPDefinitionRel)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommercePricingClassCPDefinitionRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry
				<String, Function<CommercePricingClassCPDefinitionRel, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePricingClassCPDefinitionRel, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(CommercePricingClassCPDefinitionRel)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommercePricingClassCPDefinitionRel>
				_escapedModelProxyProviderFunction =
					_getProxyProviderFunction();

	}

	private long _CommercePricingClassCPDefinitionRelId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commercePricingClassId;
	private long _originalCommercePricingClassId;
	private boolean _setOriginalCommercePricingClassId;
	private long _CPDefinitionId;
	private long _originalCPDefinitionId;
	private boolean _setOriginalCPDefinitionId;
	private long _columnBitmask;
	private CommercePricingClassCPDefinitionRel _escapedModel;

}