/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.pricing.model.impl;

import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.service.CommercePricingClassLocalServiceUtil;

/**
 * The extended model base implementation for the CommercePricingClass service. Represents a row in the &quot;CommercePricingClass&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommercePricingClassImpl}.
 * </p>
 *
 * @author Riccardo Alberti
 * @see CommercePricingClassImpl
 * @see CommercePricingClass
 * @generated
 */
public abstract class CommercePricingClassBaseImpl
	extends CommercePricingClassModelImpl implements CommercePricingClass {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce pricing class model instance should use the <code>CommercePricingClass</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommercePricingClassLocalServiceUtil.addCommercePricingClass(this);
		}
		else {
			CommercePricingClassLocalServiceUtil.updateCommercePricingClass(
				this);
		}
	}

}