/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.pricing.model.impl;

import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.service.CommercePriceModifierLocalServiceUtil;

/**
 * The extended model base implementation for the CommercePriceModifier service. Represents a row in the &quot;CommercePriceModifier&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommercePriceModifierImpl}.
 * </p>
 *
 * @author Riccardo Alberti
 * @see CommercePriceModifierImpl
 * @see CommercePriceModifier
 * @generated
 */
public abstract class CommercePriceModifierBaseImpl
	extends CommercePriceModifierModelImpl implements CommercePriceModifier {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce price modifier model instance should use the <code>CommercePriceModifier</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommercePriceModifierLocalServiceUtil.addCommercePriceModifier(
				this);
		}
		else {
			CommercePriceModifierLocalServiceUtil.updateCommercePriceModifier(
				this);
		}
	}

}