/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.upgrade.v2_0_0;

import com.liferay.commerce.pricing.internal.upgrade.base.BaseCommercePricingUpgradeProcess;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;

public class CommercePricingClassUpgradeProcess
extends BaseCommercePricingUpgradeProcess {
    private static final String[] _OWNER_PERMISSIONS = new String[]{"DELETE", "PERMISSIONS", "UPDATE", "VIEW"};
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourceLocalService _resourceLocalService;

    public CommercePricingClassUpgradeProcess(ResourceActionLocalService resourceActionLocalService, ResourceLocalService resourceLocalService) {
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourceLocalService = resourceLocalService;
    }

    @Override
    public void doUpgrade() throws Exception {
        this._resourceActionLocalService.checkResourceActions(CommercePricingClass.class.getName(), Arrays.asList(_OWNER_PERMISSIONS));
        ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])new String[0], (String[])new String[0]);
        modelPermissions.addRolePermissions("Owner", _OWNER_PERMISSIONS);
        String selectCommercePricingClassSQL = "select companyId, groupId, userId, commercePricingClassId from CommercePricingClass";
        try (Statement s = this.connection.createStatement();
             ResultSet r = s.executeQuery(selectCommercePricingClassSQL);){
            while (r.next()) {
                long companyId = r.getLong("companyId");
                long groupId = r.getLong("groupId");
                long userId = r.getLong("userId");
                long commercePricingClassId = r.getLong("commercePricingClassId");
                this._resourceLocalService.addModelResources(companyId, groupId, userId, CommercePricingClass.class.getName(), commercePricingClassId, modelPermissions);
            }
        }
        this.dropColumn("CommercePricingClass", "groupId");
    }
}

