/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.type;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.type.CommercePriceModifierType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.price.modifier.type.key=percentage", "commerce.price.modifier.type.order:Integer=20"}, service={CommercePriceModifierType.class})
public class PercentageCommercePriceModifierTypeImpl
implements CommercePriceModifierType {
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;

    public BigDecimal evaluate(BigDecimal originalPrice, CommercePriceModifier commercePriceModifier) throws PortalException {
        BigDecimal modifierAmount = commercePriceModifier.getModifierAmount();
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceModifier.getCommercePriceListId());
        CommerceCurrency commerceCurrency = commercePriceList.getCommerceCurrency();
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        BigDecimal percentage = BigDecimal.ONE.add(modifierAmount.divide(_ONE_HUNDRED));
        MathContext mathContext = new MathContext(percentage.precision(), roundingMode);
        return originalPrice.multiply(percentage, mathContext);
    }

    public String getKey() {
        return "percentage";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"percentage");
    }
}

