/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.search;

import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.service.CommercePricingClassLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommercePricingClassIndexer
extends BaseIndexer<CommercePricingClass> {
    public static final String CLASS_NAME = CommercePricingClass.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CommercePricingClassIndexer.class);
    @Reference
    private CommercePricingClassLocalService _commercePricingClassLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommercePricingClassIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "title", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
    }

    protected void doDelete(CommercePricingClass commercePricingClass) throws Exception {
        this.deleteDocument(commercePricingClass.getCompanyId(), commercePricingClass.getCommercePricingClassId());
    }

    protected Document doGetDocument(CommercePricingClass commercePricingClass) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing pricing class " + commercePricingClass));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commercePricingClass);
        document.addText("title", commercePricingClass.getTitle());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "title");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommercePricingClass commercePricingClass) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commercePricingClass.getCompanyId(), this.getDocument(commercePricingClass), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commercePricingClassLocalService.getCommercePricingClass(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommercePricingClasses(companyId);
    }

    protected void reindexCommercePricingClasses(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commercePricingClassLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commercePricingClass -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commercePricingClass)});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce pricing class " + commercePricingClass.getCommercePricingClassId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

