/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.service.impl;

import com.liferay.commerce.pricing.exception.CommercePricingClassTitleException;
import com.liferay.commerce.pricing.exception.NoSuchPricingClassException;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRelModel;
import com.liferay.commerce.pricing.service.base.CommercePricingClassLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class CommercePricingClassLocalServiceImpl
extends CommercePricingClassLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommercePricingClassLocalServiceImpl.class);

    public CommercePricingClass addCommercePricingClass(long userId, long groupId, String title, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(title);
        long commercePricingClassId = this.counterLocalService.increment();
        CommercePricingClass commercePricingClass = this.commercePricingClassPersistence.create(commercePricingClassId);
        commercePricingClass.setGroupId(groupId);
        commercePricingClass.setCompanyId(serviceContext.getCompanyId());
        commercePricingClass.setUserId(user.getUserId());
        commercePricingClass.setUserName(user.getFullName());
        commercePricingClass.setTitle(title);
        commercePricingClass.setDescription(description);
        return (CommercePricingClass)this.commercePricingClassPersistence.update((BaseModel)commercePricingClass);
    }

    @Override
    public CommercePricingClass deleteCommercePricingClass(CommercePricingClass commercePricingClass) throws PortalException {
        this.commercePricingClassCPDefinitionRelLocalService.deleteCommercePricingClassCPDefinitionRels(commercePricingClass.getCommercePricingClassId());
        return this.commercePricingClassPersistence.remove(commercePricingClass.getCommercePricingClassId());
    }

    @Override
    public CommercePricingClass deleteCommercePricingClass(long commercePricingClassId) throws PortalException {
        CommercePricingClass commercePricingClass = this.commercePricingClassPersistence.findByPrimaryKey(commercePricingClassId);
        return this.commercePricingClassLocalService.deleteCommercePricingClass(commercePricingClass);
    }

    public void deleteCommercePricingClasses(long companyId) throws PortalException {
        List commercePricingClasses = this.commercePricingClassPersistence.findByCompanyId(companyId);
        for (CommercePricingClass commercePricingClass : commercePricingClasses) {
            this.commercePricingClassLocalService.deleteCommercePricingClass(commercePricingClass);
        }
    }

    public CommercePricingClass fetchByExternalReferenceCode(long companyId, String externalReferenceCode) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commercePricingClassPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public long[] getCommercePricingClassByCPDefinition(long cpDefinitionId) {
        List commercePricingClassCPDefinitionRels = this.commercePricingClassCPDefinitionRelLocalService.getCommercePricingClassByCPDefinitionId(cpDefinitionId);
        Stream stream = commercePricingClassCPDefinitionRels.stream();
        LongStream longStream = stream.mapToLong(CommercePricingClassCPDefinitionRelModel::getCommercePricingClassId);
        return longStream.toArray();
    }

    public List<CommercePricingClass> getCommercePricingClasses(long companyId, int start, int end, OrderByComparator<CommercePricingClass> orderByComparator) {
        return this.commercePricingClassPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getCommercePricingClassesCount(long companyId) {
        return this.commercePricingClassPersistence.countByCompanyId(companyId);
    }

    public CommercePricingClass updateCommercePricingClass(long commercePricingClassId, long userId, long groupId, String title, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommercePricingClass commercePricingClass = this.commercePricingClassPersistence.findByPrimaryKey(commercePricingClassId);
        this.validate(title);
        commercePricingClass.setGroupId(groupId);
        commercePricingClass.setCompanyId(serviceContext.getCompanyId());
        commercePricingClass.setUserId(user.getUserId());
        commercePricingClass.setUserName(user.getFullName());
        commercePricingClass.setTitle(title);
        commercePricingClass.setDescription(description);
        return (CommercePricingClass)this.commercePricingClassPersistence.update((BaseModel)commercePricingClass);
    }

    public CommercePricingClass upsertCommercePricingClass(long commercePricingClassId, long userId, long groupId, String title, String description, String externalReferenceCode, ServiceContext serviceContext) throws PortalException {
        CommercePricingClass commercePricingClass;
        block4: {
            if (commercePricingClassId > 0L) {
                try {
                    return this.commercePricingClassLocalService.updateCommercePricingClass(commercePricingClassId, userId, groupId, title, description, serviceContext);
                }
                catch (NoSuchPricingClassException nspc) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Unable to find pricing class with ID: " + commercePricingClassId));
                }
            }
        }
        if (!Validator.isBlank((String)externalReferenceCode) && (commercePricingClass = this.commercePricingClassPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.commercePricingClassLocalService.updateCommercePricingClass(commercePricingClassId, userId, groupId, title, description, serviceContext);
        }
        return this.commercePricingClassLocalService.addCommercePricingClass(userId, groupId, title, description, serviceContext);
    }

    protected void validate(String title) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new CommercePricingClassTitleException();
        }
    }
}

