/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.type;

import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.type.CommercePriceModifierType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"commerce.price.modifier.type.key=absolute", "commerce.price.modifier.type.order:Integer=20"}, service={CommercePriceModifierType.class})
public class AbsoluteCommercePriceModifierTypeImpl
implements CommercePriceModifierType {
    public BigDecimal evaluate(BigDecimal originalPrice, CommercePriceModifier commercePriceModifier) throws PortalException {
        BigDecimal amount = commercePriceModifier.getModifierAmount();
        BigDecimal modifiedPrice = originalPrice.add(amount);
        if (modifiedPrice.compareTo(BigDecimal.ZERO) < 0) {
            return amount;
        }
        return modifiedPrice;
    }

    public String getKey() {
        return "absolute";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"absolute");
    }
}

