/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.service.impl;

import com.liferay.commerce.payment.model.CommercePaymentEntry;
import com.liferay.commerce.payment.service.base.CommercePaymentEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommercePaymentEntry"}, service={AopService.class})
public class CommercePaymentEntryServiceImpl
extends CommercePaymentEntryServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.payment.model.CommercePaymentEntry)")
    private ModelResourcePermission<CommercePaymentEntry> _commercePaymentEntryModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.commerce.payment)")
    private PortletResourcePermission _portletResourcePermission;

    public CommercePaymentEntry addCommercePaymentEntry(long classNameId, long classPK, long commerceChannelId, BigDecimal amount, String callbackURL, String cancelURL, String currencyCode, String languageId, String note, String payload, String paymentIntegrationKey, int paymentIntegrationType, String reasonKey, String transactionCode, int type, ServiceContext serviceContext) throws PortalException {
        String actionId = "ADD_PAYMENT";
        if (type == 1) {
            actionId = "ADD_REFUND";
        }
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), actionId);
        return this.commercePaymentEntryLocalService.addCommercePaymentEntry(this.getUserId(), classNameId, classPK, commerceChannelId, amount, callbackURL, cancelURL, currencyCode, languageId, note, payload, paymentIntegrationKey, paymentIntegrationType, reasonKey, transactionCode, type, serviceContext);
    }

    public CommercePaymentEntry addOrUpdateCommercePaymentEntry(String externalReferenceCode, long classNameId, long classPK, long commerceChannelId, BigDecimal amount, String callbackURL, String cancelURL, String currencyCode, String errorMessages, String languageId, String note, String payload, String paymentIntegrationKey, int paymentIntegrationType, int paymentStatus, String reasonKey, String redirectURL, String transactionCode, int type, ServiceContext serviceContext) throws PortalException {
        CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryLocalService.fetchCommercePaymentEntryByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        if (commercePaymentEntry == null) {
            String actionId = "ADD_PAYMENT";
            if (type == 1) {
                actionId = "ADD_REFUND";
            }
            this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), actionId);
        } else {
            this._commercePaymentEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commercePaymentEntry, "UPDATE");
        }
        return this.commercePaymentEntryLocalService.addOrUpdateCommercePaymentEntry(externalReferenceCode, this.getUserId(), classNameId, classPK, commerceChannelId, amount, callbackURL, cancelURL, currencyCode, errorMessages, languageId, note, payload, paymentIntegrationKey, paymentIntegrationType, paymentStatus, reasonKey, redirectURL, transactionCode, type, serviceContext);
    }

    public CommercePaymentEntry deleteCommercePaymentEntry(long commercePaymentEntryId) throws PortalException {
        this._commercePaymentEntryModelResourcePermission.check(this.getPermissionChecker(), commercePaymentEntryId, "DELETE");
        return this.commercePaymentEntryLocalService.deleteCommercePaymentEntry(commercePaymentEntryId);
    }

    public CommercePaymentEntry fetchCommercePaymentEntry(long commercePaymentEntryId) throws PortalException {
        CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryLocalService.fetchCommercePaymentEntry(commercePaymentEntryId);
        if (commercePaymentEntry != null) {
            this._commercePaymentEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commercePaymentEntry, "VIEW");
        }
        return commercePaymentEntry;
    }

    public CommercePaymentEntry fetchCommercePaymentEntryByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryLocalService.fetchCommercePaymentEntryByExternalReferenceCode(externalReferenceCode, companyId);
        if (commercePaymentEntry != null) {
            this._commercePaymentEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commercePaymentEntry, "VIEW");
        }
        return commercePaymentEntry;
    }

    public List<CommercePaymentEntry> getCommercePaymentEntries(long companyId, long classNameId, long classPK, int type, int start, int end, OrderByComparator<CommercePaymentEntry> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.hasPermission(null, CommercePaymentEntry.class.getName(), companyId, "VIEW")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommercePaymentEntry.class.getName(), 0L, new String[]{"VIEW"});
        }
        return this.commercePaymentEntryLocalService.getCommercePaymentEntries(companyId, classNameId, classPK, type, start, end, orderByComparator);
    }

    public List<CommercePaymentEntry> getCommercePaymentEntries(long companyId, long classNameId, long classPK, int start, int end, OrderByComparator<CommercePaymentEntry> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.hasPermission(null, CommercePaymentEntry.class.getName(), companyId, "VIEW")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommercePaymentEntry.class.getName(), 0L, new String[]{"VIEW"});
        }
        return this.commercePaymentEntryLocalService.getCommercePaymentEntries(companyId, classNameId, classPK, start, end, orderByComparator);
    }

    public int getCommercePaymentEntriesCount(long companyId, long classNameId, long classPK, int type) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.hasPermission(null, CommercePaymentEntry.class.getName(), companyId, "VIEW")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommercePaymentEntry.class.getName(), 0L, new String[]{"VIEW"});
        }
        return this.commercePaymentEntryLocalService.getCommercePaymentEntriesCount(companyId, classNameId, classPK, type);
    }

    public CommercePaymentEntry getCommercePaymentEntry(long commercePaymentEntryId) throws PortalException {
        this._commercePaymentEntryModelResourcePermission.check(this.getPermissionChecker(), commercePaymentEntryId, "VIEW");
        return this.commercePaymentEntryLocalService.getCommercePaymentEntry(commercePaymentEntryId);
    }

    public List<CommercePaymentEntry> search(long companyId, long[] classNameIds, long[] classPKs, String[] currencyCodes, String keywords, String[] paymentMethodNames, int[] paymentStatuses, boolean excludeStatuses, int start, int end, Sort sort) throws PortalException {
        BaseModelSearchResult baseModelSearchResult = this.commercePaymentEntryLocalService.searchCommercePaymentEntries(companyId, keywords, LinkedHashMapBuilder.put((Object)"classNameIds", (Object)classNameIds).put((Object)"classPKs", (Object)classPKs).put((Object)"currencyCodes", (Object)currencyCodes).put((Object)"paymentMethodNames", (Object)paymentMethodNames).put((Object)"permissionUserId", (Object)this.getPermissionChecker().getUserId()).put((Object)"paymentStatuses", (Object)paymentStatuses).put((Object)"excludeStatuses", (Object)excludeStatuses).build(), start, end, sort);
        return baseModelSearchResult.getBaseModels();
    }

    public CommercePaymentEntry updateCommercePaymentEntry(String externalReferenceCode, long commercePaymentEntryId, long commerceChannelId, BigDecimal amount, String callbackURL, String cancelURL, String currencyCode, String errorMessages, String languageId, String note, String payload, String paymentIntegrationKey, int paymentIntegrationType, int paymentStatus, String reasonKey, String redirectURL, String transactionCode, int type) throws PortalException {
        this._commercePaymentEntryModelResourcePermission.check(this.getPermissionChecker(), commercePaymentEntryId, "UPDATE");
        return this.commercePaymentEntryLocalService.updateCommercePaymentEntry(externalReferenceCode, commercePaymentEntryId, commerceChannelId, amount, callbackURL, cancelURL, currencyCode, errorMessages, languageId, note, payload, paymentIntegrationKey, paymentIntegrationType, paymentStatus, reasonKey, redirectURL, transactionCode, type);
    }

    public CommercePaymentEntry updateExternalReferenceCode(long commercePaymentEntryId, String externalReferenceCode) throws PortalException {
        this._commercePaymentEntryModelResourcePermission.check(this.getPermissionChecker(), commercePaymentEntryId, "UPDATE");
        return this.commercePaymentEntryLocalService.updateExternalReferenceCode(commercePaymentEntryId, externalReferenceCode);
    }

    public CommercePaymentEntry updateNote(long commercePaymentEntryId, String note) throws PortalException {
        this._commercePaymentEntryModelResourcePermission.check(this.getPermissionChecker(), commercePaymentEntryId, "UPDATE");
        return this.commercePaymentEntryLocalService.updateNote(commercePaymentEntryId, note);
    }

    public CommercePaymentEntry updateReasonKey(long commercePaymentEntryId, String reasonKey) throws PortalException {
        this._commercePaymentEntryModelResourcePermission.check(this.getPermissionChecker(), commercePaymentEntryId, "UPDATE");
        return this.commercePaymentEntryLocalService.updateReasonKey(commercePaymentEntryId, reasonKey);
    }
}

