/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.service.impl;

import com.liferay.commerce.payment.entry.CommercePaymentEntryRefundType;
import com.liferay.commerce.payment.entry.CommercePaymentEntryRefundTypeRegistry;
import com.liferay.commerce.payment.exception.CommercePaymentEntryAmountException;
import com.liferay.commerce.payment.exception.CommercePaymentEntryClassNameIdException;
import com.liferay.commerce.payment.exception.CommercePaymentEntryClassPKException;
import com.liferay.commerce.payment.exception.CommercePaymentEntryPaymentIntegrationTypeException;
import com.liferay.commerce.payment.exception.CommercePaymentEntryPaymentStatusException;
import com.liferay.commerce.payment.exception.CommercePaymentEntryReasonKeyException;
import com.liferay.commerce.payment.model.CommercePaymentEntry;
import com.liferay.commerce.payment.model.CommercePaymentEntryTable;
import com.liferay.commerce.payment.service.CommercePaymentEntryAuditLocalService;
import com.liferay.commerce.payment.service.base.CommercePaymentEntryLocalServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.payment.model.CommercePaymentEntry"}, service={AopService.class})
public class CommercePaymentEntryLocalServiceImpl
extends CommercePaymentEntryLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommercePaymentEntryAuditLocalService _commercePaymentEntryAuditLocalService;
    @Reference
    private CommercePaymentEntryRefundTypeRegistry _commercePaymentEntryRefundTypeRegistry;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommercePaymentEntry addCommercePaymentEntry(long userId, long classNameId, long classPK, long commerceChannelId, BigDecimal amount, String callbackURL, String cancelURL, String currencyCode, String languageId, String note, String payload, String paymentIntegrationKey, int paymentIntegrationType, String reasonKey, String transactionCode, int type, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        CommercePaymentEntryRefundType commercePaymentEntryRefundType = this._commercePaymentEntryRefundTypeRegistry.getCommercePaymentEntryRefundType(user.getCompanyId(), reasonKey);
        this._validate(commercePaymentEntryRefundType, classNameId, classPK, amount, paymentIntegrationType, 1, reasonKey, type);
        CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryPersistence.create(this.counterLocalService.increment());
        commercePaymentEntry.setCompanyId(user.getCompanyId());
        commercePaymentEntry.setUserId(user.getUserId());
        commercePaymentEntry.setUserName(user.getFullName());
        commercePaymentEntry.setClassNameId(classNameId);
        commercePaymentEntry.setClassPK(classPK);
        commercePaymentEntry.setCommerceChannelId(commerceChannelId);
        commercePaymentEntry.setAmount(amount);
        commercePaymentEntry.setCallbackURL(callbackURL);
        commercePaymentEntry.setCancelURL(cancelURL);
        commercePaymentEntry.setCurrencyCode(currencyCode);
        commercePaymentEntry.setLanguageId(languageId);
        commercePaymentEntry.setNote(note);
        commercePaymentEntry.setPayload(payload);
        commercePaymentEntry.setPaymentIntegrationKey(paymentIntegrationKey);
        commercePaymentEntry.setPaymentIntegrationType(paymentIntegrationType);
        commercePaymentEntry.setPaymentStatus(1);
        commercePaymentEntry.setReasonKey(reasonKey);
        if (commercePaymentEntryRefundType != null) {
            commercePaymentEntry.setReasonNameMap(commercePaymentEntryRefundType.getNameMap());
        }
        commercePaymentEntry.setTransactionCode(transactionCode);
        commercePaymentEntry.setType(type);
        commercePaymentEntry = (CommercePaymentEntry)this.commercePaymentEntryPersistence.update((BaseModel)commercePaymentEntry);
        this._resourceLocalService.addModelResources((AuditedModel)commercePaymentEntry, serviceContext);
        return commercePaymentEntry;
    }

    public CommercePaymentEntry addOrUpdateCommercePaymentEntry(String externalReferenceCode, long userId, long classNameId, long classPK, long commerceChannelId, BigDecimal amount, String callbackURL, String cancelURL, String currencyCode, String errorMessages, String languageId, String note, String payload, String paymentIntegrationKey, int paymentIntegrationType, int paymentStatus, String reasonKey, String redirectURL, String transactionCode, int type, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommercePaymentEntry commercePaymentEntry = null;
        if (Validator.isNotNull((String)externalReferenceCode)) {
            commercePaymentEntry = this.commercePaymentEntryPersistence.fetchByERC_C(externalReferenceCode, serviceContext.getCompanyId());
        }
        if (commercePaymentEntry != null) {
            return this.commercePaymentEntryLocalService.updateCommercePaymentEntry(externalReferenceCode, commerceChannelId, commercePaymentEntry.getCommercePaymentEntryId(), amount, callbackURL, cancelURL, currencyCode, errorMessages, languageId, note, payload, paymentIntegrationKey, paymentIntegrationType, paymentStatus, reasonKey, redirectURL, transactionCode, type);
        }
        commercePaymentEntry = this.commercePaymentEntryLocalService.addCommercePaymentEntry(userId, classNameId, classPK, commerceChannelId, amount, callbackURL, cancelURL, currencyCode, languageId, note, payload, paymentIntegrationKey, paymentIntegrationType, reasonKey, transactionCode, type, serviceContext);
        commercePaymentEntry.setExternalReferenceCode(externalReferenceCode);
        return (CommercePaymentEntry)this.commercePaymentEntryPersistence.update((BaseModel)commercePaymentEntry);
    }

    public void deleteCommercePaymentEntries(long companyId) throws PortalException {
        List commercePaymentEntries = this.commercePaymentEntryPersistence.findByCompanyId(companyId);
        for (CommercePaymentEntry commercePaymentEntry : commercePaymentEntries) {
            this.commercePaymentEntryLocalService.deleteCommercePaymentEntry(commercePaymentEntry.getCommercePaymentEntryId());
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommercePaymentEntry deleteCommercePaymentEntry(CommercePaymentEntry commercePaymentEntry) throws PortalException {
        this.commercePaymentEntryPersistence.remove((BaseModel)commercePaymentEntry);
        this._resourceLocalService.deleteResource((AuditedModel)commercePaymentEntry, 4);
        this._commercePaymentEntryAuditLocalService.deleteCommercePaymentEntryAudits(commercePaymentEntry.getCommercePaymentEntryId());
        return commercePaymentEntry;
    }

    @Override
    public CommercePaymentEntry deleteCommercePaymentEntry(long commercePaymentEntryId) throws PortalException {
        CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryPersistence.findByPrimaryKey(commercePaymentEntryId);
        return this.commercePaymentEntryLocalService.deleteCommercePaymentEntry(commercePaymentEntry);
    }

    public List<CommercePaymentEntry> getCommercePaymentEntries(long companyId, long classNameId, long classPK, int type, int start, int end, OrderByComparator<CommercePaymentEntry> orderByComparator) {
        return this.commercePaymentEntryPersistence.findByC_C_C_T(companyId, classNameId, classPK, type, start, end, orderByComparator);
    }

    public List<CommercePaymentEntry> getCommercePaymentEntries(long companyId, long classNameId, long classPK, int start, int end, OrderByComparator<CommercePaymentEntry> orderByComparator) {
        return this.commercePaymentEntryPersistence.findByC_C_C(companyId, classNameId, classPK, start, end, orderByComparator);
    }

    public int getCommercePaymentEntriesCount(long companyId, long classNameId, long classPK) {
        return this.commercePaymentEntryPersistence.countByC_C_C(companyId, classNameId, classPK);
    }

    public int getCommercePaymentEntriesCount(long companyId, long classNameId, long classPK, int type) {
        return this.commercePaymentEntryPersistence.countByC_C_C_T(companyId, classNameId, classPK, type);
    }

    public List<CommercePaymentEntry> getRefundCommercePaymentEntries(long companyId, long classNameId, long classPK, int start, int end) {
        return (List)this.dslQuery(DSLQueryFactoryUtil.select((Table)CommercePaymentEntryTable.INSTANCE).from((Table)CommercePaymentEntryTable.INSTANCE).where(this._getPredicate(companyId, classNameId, classPK)).limit(start, end));
    }

    public int getRefundCommercePaymentEntriesCount(long companyId, long classNameId, long classPK) {
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)CommercePaymentEntryTable.INSTANCE).where(this._getPredicate(companyId, classNameId, classPK)));
    }

    public BaseModelSearchResult<CommercePaymentEntry> searchCommercePaymentEntries(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(companyId, keywords, params, start, end, sort));
        SearchHits searchHits = searchResponse.getSearchHits();
        List commercePaymentEntries = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long commercePaymentEntryId = document.getLong("entryClassPK");
            CommercePaymentEntry commercePaymentEntry = this.fetchCommercePaymentEntry(commercePaymentEntryId);
            if (commercePaymentEntry == null) {
                Indexer commercePaymentEntryIndexer = IndexerRegistryUtil.getIndexer(CommercePaymentEntry.class);
                commercePaymentEntryIndexer.delete(document.getLong("companyId").longValue(), document.getString("uid"));
            }
            return commercePaymentEntry;
        });
        return new BaseModelSearchResult(commercePaymentEntries, searchResponse.getTotalHits());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePaymentEntry updateCommercePaymentEntry(String externalReferenceCode, long commercePaymentEntryId, long commerceChannelId, BigDecimal amount, String callbackURL, String cancelURL, String currencyCode, String errorMessages, String languageId, String note, String payload, String paymentIntegrationKey, int paymentIntegrationType, int paymentStatus, String reasonKey, String redirectURL, String transactionCode, int type) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryLocalService.getCommercePaymentEntry(commercePaymentEntryId);
        CommercePaymentEntryRefundType commercePaymentEntryRefundType = this._commercePaymentEntryRefundTypeRegistry.getCommercePaymentEntryRefundType(commercePaymentEntry.getCompanyId(), reasonKey);
        this._validate(commercePaymentEntryRefundType, commercePaymentEntry.getClassNameId(), commercePaymentEntry.getClassPK(), amount, paymentIntegrationType, commercePaymentEntry.getPaymentStatus(), reasonKey, type);
        commercePaymentEntry.setExternalReferenceCode(externalReferenceCode);
        commercePaymentEntry.setCommerceChannelId(commerceChannelId);
        commercePaymentEntry.setAmount(amount);
        commercePaymentEntry.setCallbackURL(callbackURL);
        commercePaymentEntry.setCancelURL(cancelURL);
        commercePaymentEntry.setCurrencyCode(currencyCode);
        commercePaymentEntry.setErrorMessages(errorMessages);
        commercePaymentEntry.setLanguageId(languageId);
        commercePaymentEntry.setNote(note);
        commercePaymentEntry.setPayload(payload);
        commercePaymentEntry.setPaymentIntegrationKey(paymentIntegrationKey);
        commercePaymentEntry.setPaymentIntegrationType(paymentIntegrationType);
        commercePaymentEntry.setPaymentStatus(paymentStatus);
        if (Validator.isNull((String)reasonKey)) {
            commercePaymentEntry.setReasonKey(null);
            commercePaymentEntry.setReasonNameMap(null);
        } else if (!reasonKey.equals(commercePaymentEntry.getReasonKey())) {
            commercePaymentEntry.setReasonKey(reasonKey);
            commercePaymentEntry.setReasonNameMap(commercePaymentEntryRefundType.getNameMap());
        }
        commercePaymentEntry.setRedirectURL(redirectURL);
        if (Validator.isNotNull((String)transactionCode)) {
            commercePaymentEntry.setTransactionCode(transactionCode);
        }
        commercePaymentEntry.setType(type);
        return (CommercePaymentEntry)this.commercePaymentEntryPersistence.update((BaseModel)commercePaymentEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePaymentEntry updateExternalReferenceCode(long commercePaymentEntryId, String externalReferenceCode) throws PortalException {
        CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryPersistence.findByPrimaryKey(commercePaymentEntryId);
        commercePaymentEntry.setExternalReferenceCode(externalReferenceCode);
        return (CommercePaymentEntry)this.commercePaymentEntryPersistence.update((BaseModel)commercePaymentEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePaymentEntry updateNote(long commercePaymentEntryId, String note) throws PortalException {
        CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryLocalService.getCommercePaymentEntry(commercePaymentEntryId);
        commercePaymentEntry.setNote(note);
        return (CommercePaymentEntry)this.commercePaymentEntryPersistence.update((BaseModel)commercePaymentEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePaymentEntry updateReasonKey(long commercePaymentEntryId, String reasonKey) throws PortalException {
        CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryLocalService.getCommercePaymentEntry(commercePaymentEntryId);
        CommercePaymentEntryRefundType commercePaymentEntryRefundType = this._commercePaymentEntryRefundTypeRegistry.getCommercePaymentEntryRefundType(commercePaymentEntry.getCompanyId(), reasonKey);
        this._validate(commercePaymentEntryRefundType, commercePaymentEntry.getClassNameId(), commercePaymentEntry.getClassPK(), commercePaymentEntry.getAmount(), commercePaymentEntry.getPaymentIntegrationType(), commercePaymentEntry.getPaymentStatus(), reasonKey, commercePaymentEntry.getType());
        if (Validator.isNull((String)reasonKey)) {
            commercePaymentEntry.setReasonKey(null);
            commercePaymentEntry.setReasonNameMap(null);
        } else if (!reasonKey.equals(commercePaymentEntry.getReasonKey())) {
            commercePaymentEntry.setReasonKey(reasonKey);
            commercePaymentEntry.setReasonNameMap(commercePaymentEntryRefundType.getNameMap());
        }
        return (CommercePaymentEntry)this.commercePaymentEntryPersistence.update((BaseModel)commercePaymentEntry);
    }

    private Predicate _getPredicate(long companyId, long classNameId, long classPK) {
        return CommercePaymentEntryTable.INSTANCE.classPK.in((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{CommercePaymentEntryTable.INSTANCE.commercePaymentEntryId}).from((Table)CommercePaymentEntryTable.INSTANCE).where(CommercePaymentEntryTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommercePaymentEntryTable.INSTANCE.classNameId.eq((Object)classNameId)).and((Expression)CommercePaymentEntryTable.INSTANCE.classPK.eq((Object)classPK)).and((Expression)CommercePaymentEntryTable.INSTANCE.paymentStatus.eq((Object)0)).and((Expression)CommercePaymentEntryTable.INSTANCE.type.eq((Object)0)))).and((Expression)CommercePaymentEntryTable.INSTANCE.type.eq((Object)1));
    }

    private SearchRequest _getSearchRequest(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{CommercePaymentEntry.class.getName()}).emptySearchEnabled(true).highlightEnabled(false).withSearchContext(searchContext -> this._populateSearchContext((SearchContext)searchContext, companyId, keywords, params, sort));
        if (start != -1) {
            searchRequestBuilder.from(Integer.valueOf(start));
            searchRequestBuilder.size(Integer.valueOf(end));
        }
        return searchRequestBuilder.build();
    }

    private void _populateSearchContext(SearchContext searchContext, long companyId, String keywords, LinkedHashMap<String, Object> params, Sort sort) {
        int[] statuses;
        long permissionUserId;
        Object[] paymentMethodNames;
        Object[] currencyCodes;
        long[] classPKs;
        searchContext.setCompanyId(companyId);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (MapUtil.isEmpty(params)) {
            return;
        }
        long[] classNameIds = (long[])params.get("classNameIds");
        if (ArrayUtil.isNotEmpty((long[])classNameIds)) {
            searchContext.setAttribute("classNameIds", (Serializable)classNameIds);
        }
        if (ArrayUtil.isNotEmpty((long[])(classPKs = (long[])params.get("classPKs")))) {
            searchContext.setAttribute("classPKs", (Serializable)classPKs);
        }
        if (ArrayUtil.isNotEmpty((Object[])(currencyCodes = (String[])params.get("currencyCodes")))) {
            searchContext.setAttribute("currencyCodes", (Serializable)currencyCodes);
        }
        if (ArrayUtil.isNotEmpty((Object[])(paymentMethodNames = (String[])params.get("paymentMethodNames")))) {
            searchContext.setAttribute("paymentMethodNames", (Serializable)paymentMethodNames);
        }
        if ((permissionUserId = GetterUtil.getLong((Object)params.get("permissionUserId"))) > 0L) {
            searchContext.setUserId(permissionUserId);
        }
        if (ArrayUtil.isNotEmpty((int[])(statuses = (int[])params.get("paymentStatuses")))) {
            searchContext.setAttribute("paymentStatuses", (Serializable)statuses);
        }
        boolean excludeStatuses = GetterUtil.getBoolean((Object)params.get("excludePaymentStatuses"));
        searchContext.setAttribute("excludePaymentStatuses", (Serializable)Boolean.valueOf(excludeStatuses));
        Integer type = (Integer)params.get("type");
        if (type != null) {
            searchContext.setAttribute("type", (Serializable)type);
        }
        if (sort == null) {
            sort = SortFactoryUtil.getSort(CommercePaymentEntry.class, (int)6, (String)"createDate", (String)"DESC");
        } else {
            sort.setFieldName("createDate");
            sort.setType(6);
        }
        searchContext.setSorts(new Sort[]{sort});
    }

    private void _validate(CommercePaymentEntryRefundType commercePaymentEntryRefundType, long classNameId, long classPK, BigDecimal amount, int paymentIntegrationType, int paymentStatus, String reasonKey, int type) throws PortalException {
        if (classNameId <= 0L) {
            throw new CommercePaymentEntryClassNameIdException();
        }
        if (type == 1) {
            if (classNameId != this._classNameLocalService.getClassNameId(CommercePaymentEntry.class.getName())) {
                throw new CommercePaymentEntryClassNameIdException();
            }
            CommercePaymentEntry commercePaymentEntry = this.commercePaymentEntryPersistence.fetchByPrimaryKey(classPK);
            if (commercePaymentEntry == null || commercePaymentEntry.getPaymentStatus() != 0) {
                throw new CommercePaymentEntryClassPKException();
            }
        }
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new CommercePaymentEntryAmountException();
        }
        if (paymentIntegrationType < 0) {
            throw new CommercePaymentEntryPaymentIntegrationTypeException();
        }
        if (paymentStatus == 17) {
            throw new CommercePaymentEntryPaymentStatusException();
        }
        if (Validator.isNotNull((String)reasonKey) && (commercePaymentEntryRefundType == null || type != 1)) {
            throw new CommercePaymentEntryReasonKeyException();
        }
    }
}

