/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.gateway;

import com.liferay.commerce.payment.audit.CommercePaymentEntryAuditType;
import com.liferay.commerce.payment.audit.CommercePaymentEntryAuditTypeRegistry;
import com.liferay.commerce.payment.configuration.CommercePaymentEntryAuditConfiguration;
import com.liferay.commerce.payment.gateway.CommercePaymentGateway;
import com.liferay.commerce.payment.integration.CommercePaymentIntegration;
import com.liferay.commerce.payment.model.CommercePaymentEntry;
import com.liferay.commerce.payment.service.CommercePaymentEntryAuditLocalService;
import com.liferay.commerce.payment.service.CommercePaymentEntryLocalService;
import com.liferay.commerce.payment.util.CommercePaymentHelper;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import javax.persistence.OptimisticLockException;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommercePaymentGateway.class})
public class CommercePaymentGatewayImpl
implements CommercePaymentGateway {
    private static final Log _log = LogFactoryUtil.getLog(CommercePaymentGatewayImpl.class);
    @Reference
    private CommercePaymentEntryAuditLocalService _commercePaymentEntryAuditLocalService;
    @Reference
    private CommercePaymentEntryAuditTypeRegistry _commercePaymentEntryAuditTypeRegistry;
    @Reference
    private CommercePaymentEntryLocalService _commercePaymentEntryLocalService;
    @Reference
    private CommercePaymentHelper _commercePaymentHelper;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference
    private Portal _portal;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentEntry authorize(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        CommercePaymentIntegration commercePaymentIntegration = this._commercePaymentHelper.getCommercePaymentIntegration(commercePaymentEntry.getCommerceChannelId(), commercePaymentEntry.getPaymentIntegrationKey());
        CommercePaymentEntry authorizedCommercePaymentEntry = commercePaymentIntegration.authorize(httpServletRequest, commercePaymentEntry);
        if (StringUtil.equals((String)(commercePaymentEntry = this._commercePaymentEntryLocalService.fetchCommercePaymentEntry(commercePaymentEntry.getCommercePaymentEntryId())).getErrorMessages(), (String)authorizedCommercePaymentEntry.getErrorMessages()) && StringUtil.equals((String)commercePaymentEntry.getPayload(), (String)authorizedCommercePaymentEntry.getPayload()) && commercePaymentEntry.getPaymentStatus() == authorizedCommercePaymentEntry.getPaymentStatus() && StringUtil.equals((String)commercePaymentEntry.getRedirectURL(), (String)authorizedCommercePaymentEntry.getRedirectURL()) && StringUtil.equals((String)commercePaymentEntry.getTransactionCode(), (String)authorizedCommercePaymentEntry.getTransactionCode())) {
            return commercePaymentEntry;
        }
        User currentUser = this._portal.getUser(httpServletRequest);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(currentUser));
        try {
            commercePaymentEntry = this._commercePaymentEntryLocalService.updateCommercePaymentEntry(commercePaymentEntry.getExternalReferenceCode(), commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentEntry.getCommerceChannelId(), commercePaymentEntry.getAmount(), commercePaymentEntry.getCallbackURL(), commercePaymentEntry.getCancelURL(), commercePaymentEntry.getCurrencyCode(), authorizedCommercePaymentEntry.getErrorMessages(), commercePaymentEntry.getLanguageId(), commercePaymentEntry.getNote(), commercePaymentEntry.getPayload(), commercePaymentEntry.getPaymentIntegrationKey(), commercePaymentEntry.getPaymentIntegrationType(), authorizedCommercePaymentEntry.getPaymentStatus(), commercePaymentEntry.getReasonKey(), authorizedCommercePaymentEntry.getRedirectURL(), authorizedCommercePaymentEntry.getTransactionCode(), commercePaymentEntry.getType());
        }
        catch (Exception exception) {
            this._logOptimisticLockException(exception);
        }
        CommercePaymentEntryAuditConfiguration commercePaymentEntryAuditConfiguration = this._getCommercePaymentEntryAuditConfiguration(commercePaymentEntry.getCompanyId());
        if (commercePaymentEntryAuditConfiguration.enabled()) {
            CommercePaymentEntryAuditType commercePaymentEntryAuditType = this._commercePaymentEntryAuditTypeRegistry.getCommercePaymentEntryAuditType("authorize-payment");
            this._commercePaymentEntryAuditLocalService.addCommercePaymentEntryAudit(currentUser.getUserId(), commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentEntry.getAmount(), commercePaymentEntry.getCurrencyCode(), commercePaymentEntryAuditType.getType(), commercePaymentEntryAuditType.getLog((Map)HashMapBuilder.put((Object)"classNameId", (Object)commercePaymentEntry.getClassNameId()).put((Object)"classPK", (Object)String.valueOf(commercePaymentEntry.getClassPK())).build()), this._createServiceContext(currentUser));
        }
        return commercePaymentEntry;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentEntry cancel(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        CommercePaymentIntegration commercePaymentIntegration = this._commercePaymentHelper.getCommercePaymentIntegration(commercePaymentEntry.getCommerceChannelId(), commercePaymentEntry.getPaymentIntegrationKey());
        CommercePaymentEntry cancelledCommercePaymentEntry = commercePaymentIntegration.cancel(httpServletRequest, commercePaymentEntry);
        User currentUser = this._portal.getUser(httpServletRequest);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(currentUser));
        commercePaymentEntry = this._commercePaymentEntryLocalService.updateCommercePaymentEntry(commercePaymentEntry.getExternalReferenceCode(), commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentEntry.getCommerceChannelId(), commercePaymentEntry.getAmount(), commercePaymentEntry.getCallbackURL(), commercePaymentEntry.getCancelURL(), commercePaymentEntry.getCurrencyCode(), cancelledCommercePaymentEntry.getErrorMessages(), commercePaymentEntry.getLanguageId(), commercePaymentEntry.getNote(), commercePaymentEntry.getPayload(), commercePaymentEntry.getPaymentIntegrationKey(), commercePaymentEntry.getPaymentIntegrationType(), cancelledCommercePaymentEntry.getPaymentStatus(), commercePaymentEntry.getReasonKey(), cancelledCommercePaymentEntry.getRedirectURL(), cancelledCommercePaymentEntry.getTransactionCode(), commercePaymentEntry.getType());
        CommercePaymentEntryAuditConfiguration commercePaymentEntryAuditConfiguration = this._getCommercePaymentEntryAuditConfiguration(commercePaymentEntry.getCompanyId());
        if (commercePaymentEntryAuditConfiguration.enabled()) {
            CommercePaymentEntryAuditType commercePaymentEntryAuditType = this._commercePaymentEntryAuditTypeRegistry.getCommercePaymentEntryAuditType("cancel-payment");
            this._commercePaymentEntryAuditLocalService.addCommercePaymentEntryAudit(currentUser.getUserId(), commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentEntry.getAmount(), commercePaymentEntry.getCurrencyCode(), commercePaymentEntryAuditType.getType(), commercePaymentEntryAuditType.getLog((Map)HashMapBuilder.put((Object)"classNameId", (Object)commercePaymentEntry.getClassNameId()).put((Object)"classPK", (Object)String.valueOf(commercePaymentEntry.getClassPK())).build()), this._createServiceContext(currentUser));
        }
        return commercePaymentEntry;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentEntry capture(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        String transactionCode = commercePaymentEntry.getTransactionCode();
        CommercePaymentIntegration commercePaymentIntegration = this._commercePaymentHelper.getCommercePaymentIntegration(commercePaymentEntry.getCommerceChannelId(), commercePaymentEntry.getPaymentIntegrationKey());
        CommercePaymentEntry capturedCommercePaymentEntry = commercePaymentIntegration.capture(httpServletRequest, commercePaymentEntry);
        if (StringUtil.equals((String)(commercePaymentEntry = this._commercePaymentEntryLocalService.fetchCommercePaymentEntry(commercePaymentEntry.getCommercePaymentEntryId())).getErrorMessages(), (String)capturedCommercePaymentEntry.getErrorMessages()) && StringUtil.equals((String)commercePaymentEntry.getPayload(), (String)capturedCommercePaymentEntry.getPayload()) && commercePaymentEntry.getPaymentStatus() == capturedCommercePaymentEntry.getPaymentStatus() && StringUtil.equals((String)commercePaymentEntry.getRedirectURL(), (String)capturedCommercePaymentEntry.getRedirectURL()) && StringUtil.equals((String)transactionCode, (String)capturedCommercePaymentEntry.getTransactionCode())) {
            return commercePaymentEntry;
        }
        User currentUser = this._portal.getUser(httpServletRequest);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(currentUser));
        try {
            commercePaymentEntry = this._commercePaymentEntryLocalService.updateCommercePaymentEntry(commercePaymentEntry.getExternalReferenceCode(), commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentEntry.getCommerceChannelId(), commercePaymentEntry.getAmount(), commercePaymentEntry.getCallbackURL(), commercePaymentEntry.getCancelURL(), commercePaymentEntry.getCurrencyCode(), capturedCommercePaymentEntry.getErrorMessages(), commercePaymentEntry.getLanguageId(), commercePaymentEntry.getNote(), capturedCommercePaymentEntry.getPayload(), commercePaymentEntry.getPaymentIntegrationKey(), commercePaymentEntry.getPaymentIntegrationType(), capturedCommercePaymentEntry.getPaymentStatus(), commercePaymentEntry.getReasonKey(), capturedCommercePaymentEntry.getRedirectURL(), capturedCommercePaymentEntry.getTransactionCode(), commercePaymentEntry.getType());
        }
        catch (Exception exception) {
            this._logOptimisticLockException(exception);
        }
        CommercePaymentEntryAuditConfiguration commercePaymentEntryAuditConfiguration = this._getCommercePaymentEntryAuditConfiguration(commercePaymentEntry.getCompanyId());
        if (commercePaymentEntryAuditConfiguration.enabled()) {
            CommercePaymentEntryAuditType commercePaymentEntryAuditType = this._commercePaymentEntryAuditTypeRegistry.getCommercePaymentEntryAuditType("capture-payment");
            this._commercePaymentEntryAuditLocalService.addCommercePaymentEntryAudit(currentUser.getUserId(), commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentEntry.getAmount(), commercePaymentEntry.getCurrencyCode(), commercePaymentEntryAuditType.getType(), commercePaymentEntryAuditType.getLog((Map)HashMapBuilder.put((Object)"classNameId", (Object)commercePaymentEntry.getClassNameId()).put((Object)"classPK", (Object)String.valueOf(commercePaymentEntry.getClassPK())).build()), this._createServiceContext(currentUser));
        }
        return commercePaymentEntry;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentEntry refund(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        CommercePaymentIntegration commercePaymentIntegration = this._commercePaymentHelper.getCommercePaymentIntegration(commercePaymentEntry.getCommerceChannelId(), commercePaymentEntry.getPaymentIntegrationKey());
        CommercePaymentEntry refundedCommercePaymentEntry = commercePaymentIntegration.refund(httpServletRequest, commercePaymentEntry);
        User currentUser = this._portal.getUser(httpServletRequest);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(currentUser));
        commercePaymentEntry = this._commercePaymentEntryLocalService.updateCommercePaymentEntry(commercePaymentEntry.getExternalReferenceCode(), commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentEntry.getCommerceChannelId(), commercePaymentEntry.getAmount(), commercePaymentEntry.getCallbackURL(), commercePaymentEntry.getCancelURL(), commercePaymentEntry.getCurrencyCode(), refundedCommercePaymentEntry.getErrorMessages(), commercePaymentEntry.getLanguageId(), commercePaymentEntry.getNote(), commercePaymentEntry.getPayload(), commercePaymentEntry.getPaymentIntegrationKey(), commercePaymentEntry.getPaymentIntegrationType(), refundedCommercePaymentEntry.getPaymentStatus(), commercePaymentEntry.getReasonKey(), refundedCommercePaymentEntry.getRedirectURL(), refundedCommercePaymentEntry.getTransactionCode(), commercePaymentEntry.getType());
        CommercePaymentEntryAuditConfiguration commercePaymentEntryAuditConfiguration = this._getCommercePaymentEntryAuditConfiguration(commercePaymentEntry.getCompanyId());
        if (commercePaymentEntryAuditConfiguration.enabled()) {
            CommercePaymentEntryAuditType commercePaymentEntryAuditType = this._commercePaymentEntryAuditTypeRegistry.getCommercePaymentEntryAuditType("refund-payment");
            this._commercePaymentEntryAuditLocalService.addCommercePaymentEntryAudit(currentUser.getUserId(), commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentEntry.getAmount(), commercePaymentEntry.getCurrencyCode(), commercePaymentEntryAuditType.getType(), commercePaymentEntryAuditType.getLog((Map)HashMapBuilder.put((Object)"classNameId", (Object)commercePaymentEntry.getClassNameId()).put((Object)"classPK", (Object)String.valueOf(commercePaymentEntry.getClassPK())).build()), this._createServiceContext(currentUser));
        }
        return commercePaymentEntry;
    }

    public CommercePaymentEntry setUpPayment(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        CommercePaymentIntegration commercePaymentIntegration = this._commercePaymentHelper.getCommercePaymentIntegration(commercePaymentEntry.getCommerceChannelId(), commercePaymentEntry.getPaymentIntegrationKey());
        return commercePaymentIntegration.setUpPayment(httpServletRequest, commercePaymentEntry);
    }

    private ServiceContext _createServiceContext(final User user) {
        return new ServiceContext(){
            {
                this.setCompanyId(user.getCompanyId());
                this.setUserId(user.getUserId());
            }
        };
    }

    private CommercePaymentEntryAuditConfiguration _getCommercePaymentEntryAuditConfiguration(long companyId) throws ConfigurationException {
        return (CommercePaymentEntryAuditConfiguration)this._configurationProvider.getCompanyConfiguration(CommercePaymentEntryAuditConfiguration.class, companyId);
    }

    private void _logOptimisticLockException(Exception exception) {
        if (!(exception.getCause() instanceof SystemException)) {
            return;
        }
        Throwable throwable = exception.getCause();
        if (!(throwable instanceof ORMException)) {
            return;
        }
        if (!((throwable = throwable.getCause()) instanceof OptimisticLockException) || !_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)"Ignore duplicate calls. See LPD-28950.", (Throwable)exception);
    }
}

