/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.entry;

import com.liferay.commerce.payment.entry.CommercePaymentEntryRefundType;
import com.liferay.commerce.payment.entry.CommercePaymentEntryRefundTypeRegistry;
import com.liferay.commerce.payment.internal.entry.comparator.CommercePaymentEntryRefundTypeOrderComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={CommercePaymentEntryRefundTypeRegistry.class})
public class CommercePaymentEntryRefundTypeRegistryImpl
implements CommercePaymentEntryRefundTypeRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommercePaymentEntryRefundTypeRegistryImpl.class);
    private final Comparator<CommercePaymentEntryRefundType> _commercePaymentEntryRefundTypeOrderComparator = new CommercePaymentEntryRefundTypeOrderComparator();
    private ServiceTrackerMap<ScopedKey, CommercePaymentEntryRefundType> _serviceTrackerMap;

    public CommercePaymentEntryRefundType getCommercePaymentEntryRefundType(long companyId, String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        CommercePaymentEntryRefundType commercePaymentEntryRefundType = (CommercePaymentEntryRefundType)this._serviceTrackerMap.getService((Object)new ScopedKey(companyId, key));
        if (commercePaymentEntryRefundType == null && _log.isDebugEnabled()) {
            _log.debug((Object)("No commerce payment entry refund type registered with key " + key));
        }
        return commercePaymentEntryRefundType;
    }

    public List<CommercePaymentEntryRefundType> getCommercePaymentEntryRefundTypes(long companyId) {
        ArrayList<Object> commercePaymentEntryRefundTypes = new ArrayList<Object>();
        for (ScopedKey scopedKey : this._serviceTrackerMap.keySet()) {
            if (companyId != scopedKey._companyId) continue;
            commercePaymentEntryRefundTypes.add(this._serviceTrackerMap.getService((Object)scopedKey));
        }
        commercePaymentEntryRefundTypes.sort(this._commercePaymentEntryRefundTypeOrderComparator);
        return Collections.unmodifiableList(commercePaymentEntryRefundTypes);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommercePaymentEntryRefundType.class, (String)"(enabled=true)", (serviceReference, emitter) -> emitter.emit((Object)new ScopedKey(GetterUtil.getLong((Object)serviceReference.getProperty("companyId")), String.valueOf(serviceReference.getProperty("key")))));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private static class ScopedKey {
        private final long _companyId;
        private final String _key;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ScopedKey)) {
                return false;
            }
            ScopedKey scopedKey = (ScopedKey)object;
            return this._companyId == scopedKey._companyId && Objects.equals(this._key, scopedKey._key);
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (long)this._companyId);
            return HashUtil.hash((int)hash, (Object)this._key);
        }

        private ScopedKey(long companyId, String key) {
            this._companyId = companyId;
            this._key = key;
        }
    }
}

