/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.audit;

import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.payment.audit.CommercePaymentEntryAuditType;
import com.liferay.commerce.payment.model.CommercePaymentEntryAudit;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.payment.entry.audit.type.key=refund-payment"}, service={CommercePaymentEntryAuditType.class})
public class RefundPaymentCommercePaymentEntryAuditType
implements CommercePaymentEntryAuditType {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public String formatAmount(CommercePaymentEntryAudit commercePaymentEntryAudit, Locale locale) throws PortalException {
        return this._commercePriceFormatter.format(this._commerceCurrencyLocalService.getCommerceCurrency(commercePaymentEntryAudit.getCompanyId(), commercePaymentEntryAudit.getCurrencyCode()), commercePaymentEntryAudit.getAmount(), locale);
    }

    public String formatLog(CommercePaymentEntryAudit commercePaymentEntryAudit, Locale locale) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(commercePaymentEntryAudit.getLogTypeSettings());
        long classNameId = (Long)jsonObject.get("classNameId");
        return StringBundler.concat((String[])new String[]{this._language.format(locale, "payment-refund-for-x", (Object)this._classNameLocalService.getClassName(classNameId)), ", ", this._language.format(locale, "id-x", jsonObject.get("classPK"))});
    }

    public String getLog(Map<String, Object> context) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return jsonObject.toString();
    }

    public String getType() {
        return "refund-payment";
    }
}

